/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.states.FunctionStorageKey;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.datarow.ExpressionDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndReportHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndSubReportHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class ReportDoneHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new ReportDoneHandler();

    private ReportDoneHandler() {
    }

    @Override
    public int getEventCode() {
        return 512;
    }

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.fireReportEvent();
        if (next.isSubReportEvent() && next.getLevel() == -2) {
            next.firePageFinishedEvent(true);
        }
        return next;
    }

    @Override
    public ProcessState commit(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        DefaultFlowController flowController = next.getFlowController();
        MasterDataRow masterRow = flowController.getMasterRow();
        ExpressionDataRow expressionDataRow = masterRow.getExpressionDataRow();
        Expression[] expressions = expressionDataRow.getExpressions();
        if (next.isSubReportEvent()) {
            next.setAdvanceHandler(EndSubReportHandler.HANDLER);
        } else {
            next.setAdvanceHandler(EndReportHandler.HANDLER);
        }
        ReportState parentState = next.getParentSubReportState();
        ReportStateKey parentStateKey = parentState == null ? null : parentState.getProcessKey();
        FunctionStorageKey functionStorageKey = FunctionStorageKey.createKey(parentStateKey, next.getReport());
        next.getFunctionStorage().store(functionStorageKey, expressions, expressionDataRow.getColumnCount());
        Expression[] structureFunctions = next.getLayoutProcess().getCollectionFunctions();
        next.getStructureFunctionStorage().store(functionStorageKey, structureFunctions, structureFunctions.length);
        DefaultFlowController pfc = flowController.performClearExportedParameters();
        DefaultFlowController efc = pfc.deactivateExpressions();
        if (next.isSubReportEvent()) {
            DefaultFlowController qfcSr = efc.performReturnFromSubreport();
            next.setFlowController(qfcSr);
        } else {
            DefaultFlowController qfc = efc.performReturnFromQuery();
            next.setFlowController(qfc);
        }
        return next;
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

