/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.AbstractElementReadHandler;
import org.pentaho.reporting.engine.classic.core.style.FontSmooth;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractTextElementReadHandler
extends AbstractElementReadHandler {
    public static final String RESERVED_LITERAL_ATT = "reserved-literal";
    public static final String TRIM_TEXT_CONTENT_ATT = "trim-text-content";
    public static final String EXCEL_WRAP_TEXT = "excel-wrap-text";

    protected AbstractTextElementReadHandler() {
    }

    protected abstract TextElementFactory getTextElementFactory();

    @Override
    protected final ElementFactory getElementFactory() {
        return this.getTextElementFactory();
    }

    @Override
    protected void startParsing(PropertyAttributes atts) throws SAXException {
        String optLetterSpacing;
        String maxLetterSpacing;
        super.startParsing(atts);
        TextElementFactory factory = this.getTextElementFactory();
        factory.setVerticalTextAlignment(ReportParserUtil.parseVerticalTextElementAlignment(atts.getValue(this.getUri(), "vertical-text-alignment"), this.getLocator()));
        factory.setBold(ParserUtil.parseBoolean((String)atts.getValue(this.getUri(), "fsbold"), (Locator)this.getLocator()));
        factory.setEmbedFont(ParserUtil.parseBoolean((String)atts.getValue(this.getUri(), "font-embedded"), (Locator)this.getLocator()));
        factory.setWrapText(ParserUtil.parseBoolean((String)atts.getValue(this.getUri(), EXCEL_WRAP_TEXT), (Locator)this.getLocator()));
        factory.setEncoding(atts.getValue(this.getUri(), "font-encoding"));
        factory.setFontName(atts.getValue(this.getUri(), "fontname"));
        factory.setFontSize(ReportParserUtil.parseInteger(atts.getValue(this.getUri(), "fontsize"), this.getLocator()));
        factory.setItalic(ParserUtil.parseBoolean((String)atts.getValue(this.getUri(), "fsitalic"), (Locator)this.getLocator()));
        factory.setLineHeight(ReportParserUtil.parseFloat(atts.getValue(this.getUri(), "line-height"), this.getLocator()));
        factory.setStrikethrough(ParserUtil.parseBoolean((String)atts.getValue(this.getUri(), "fsstrikethr"), (Locator)this.getLocator()));
        factory.setUnderline(ParserUtil.parseBoolean((String)atts.getValue(this.getUri(), "fsunderline"), (Locator)this.getLocator()));
        factory.setReservedLiteral(atts.getValue(this.getUri(), RESERVED_LITERAL_ATT));
        factory.setTrimTextContent(ParserUtil.parseBoolean((String)atts.getValue(this.getUri(), TRIM_TEXT_CONTENT_ATT), (Locator)this.getLocator()));
        this.parseSimpleFontStyle(atts.getValue(this.getUri(), "fontstyle"), factory);
        factory.setWhitespaceCollapse(this.parseWhitespaceCollapse(atts.getValue(this.getUri(), "whitespace-collapse")));
        factory.setVerticalTextAlignment(this.parseVerticalTextAlign(atts.getValue(this.getUri(), "vertical-text-alignment")));
        factory.setWrap(this.parseTextWrap(atts.getValue(this.getUri(), "wrap")));
        factory.setFontSmooth(this.parseFontSmooth(atts.getValue(this.getUri(), "fontsmooth")));
        String minLetterSpacing = atts.getValue(this.getUri(), "minimum-letter-spacing");
        if (minLetterSpacing != null) {
            factory.setMinimumLetterSpacing(ReportParserUtil.parseFloat(minLetterSpacing, this.getLocator()));
        }
        if ((maxLetterSpacing = atts.getValue(this.getUri(), "maximum-letter-spacing")) != null) {
            factory.setMaximumLetterSpacing(ReportParserUtil.parseFloat(maxLetterSpacing, this.getLocator()));
        }
        if ((optLetterSpacing = atts.getValue(this.getUri(), "optimum-letter-spacing")) != null) {
            factory.setOptimumLetterSpacing(ReportParserUtil.parseFloat(optLetterSpacing, this.getLocator()));
        }
    }

    private WhitespaceCollapse parseWhitespaceCollapse(String attr) {
        if ("discard".equalsIgnoreCase(attr)) {
            return WhitespaceCollapse.DISCARD;
        }
        if ("collapse".equalsIgnoreCase(attr)) {
            return WhitespaceCollapse.COLLAPSE;
        }
        if ("preserve".equalsIgnoreCase(attr)) {
            return WhitespaceCollapse.PRESERVE;
        }
        if ("preserve-breaks".equalsIgnoreCase(attr)) {
            return WhitespaceCollapse.PRESERVE_BREAKS;
        }
        return null;
    }

    private VerticalTextAlign parseVerticalTextAlign(String attr) {
        if ("use-script".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.USE_SCRIPT;
        }
        if ("text-bottom".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.TEXT_BOTTOM;
        }
        if ("bottom".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.BOTTOM;
        }
        if ("text-top".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.TEXT_TOP;
        }
        if ("top".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.TOP;
        }
        if ("central".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.CENTRAL;
        }
        if ("middle".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.MIDDLE;
        }
        if ("sub".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.SUB;
        }
        if ("super".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.SUPER;
        }
        if ("baseline".equalsIgnoreCase(attr)) {
            return VerticalTextAlign.BASELINE;
        }
        return null;
    }

    private FontSmooth parseFontSmooth(String attr) {
        if ("always".equalsIgnoreCase(attr)) {
            return FontSmooth.ALWAYS;
        }
        if ("never".equalsIgnoreCase(attr)) {
            return FontSmooth.NEVER;
        }
        if ("auto".equalsIgnoreCase(attr)) {
            return FontSmooth.AUTO;
        }
        return null;
    }

    private TextWrap parseTextWrap(String attr) {
        if ("wrap".equalsIgnoreCase(attr)) {
            return TextWrap.WRAP;
        }
        if ("none".equalsIgnoreCase(attr)) {
            return TextWrap.NONE;
        }
        return null;
    }

    private void parseSimpleFontStyle(String fontStyle, TextElementFactory target) {
        if (fontStyle != null) {
            if ("bold".equals(fontStyle)) {
                target.setBold(Boolean.TRUE);
                target.setItalic(Boolean.FALSE);
            } else if ("italic".equals(fontStyle)) {
                target.setBold(Boolean.FALSE);
                target.setItalic(Boolean.TRUE);
            } else if ("bold-italic".equals(fontStyle)) {
                target.setBold(Boolean.TRUE);
                target.setItalic(Boolean.TRUE);
            } else if ("plain".equals(fontStyle)) {
                target.setBold(Boolean.FALSE);
                target.setItalic(Boolean.FALSE);
            }
        }
    }
}

