/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Color;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.libraries.base.util.LFUMap;

public class CachingExcelColorSupport
implements ExcelColorProducer {
    private ExcelColorProducer base;
    private LFUMap<Integer, Short> colorCache;

    public CachingExcelColorSupport(ExcelColorProducer base) {
        if (base == null) {
            throw new NullPointerException();
        }
        this.base = base;
        this.colorCache = new LFUMap(5000);
    }

    @Override
    public short getNearestColor(Color awtColor) {
        Short value = (Short)this.colorCache.get((Object)awtColor.getRGB());
        if (value != null) {
            return value;
        }
        short nearestColor = this.base.getNearestColor(awtColor);
        this.colorCache.put((Object)awtColor.getRGB(), (Object)nearestColor);
        return nearestColor;
    }
}

