/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.awt.Color;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SlimSheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlRowBackgroundStruct;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultStyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilderFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleManager;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.util.HtmlColors;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;

public class HtmlTagHelper {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private Configuration configuration;
    private StyleBuilderFactory styleBuilderFactory;
    private StyleBuilder styleBuilder;
    private StyleManager styleManager;

    public HtmlTagHelper(Configuration configuration, StyleBuilderFactory styleBuilderFactory) {
        this.configuration = configuration;
        this.styleBuilderFactory = styleBuilderFactory;
        this.styleBuilder = new DefaultStyleBuilder(styleBuilderFactory);
    }

    public StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    public StyleBuilderFactory getStyleBuilderFactory() {
        return this.styleBuilderFactory;
    }

    public StyleManager getStyleManager() {
        return this.styleManager;
    }

    public void setStyleManager(StyleManager styleManager) {
        this.styleManager = styleManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public AttributeList createCellAttributes(int colSpan, int rowSpan, ReportAttributeMap<Object> content, StyleSheet styleSheet, CellBackground background, StyleBuilder styleBuilder) {
        ReportAttributeMap<Object> attrs;
        AttributeList attrList = new AttributeList();
        if (content != null) {
            if (rowSpan > 1) {
                attrList.setAttribute(XHTML_NAMESPACE, "rowspan", String.valueOf(rowSpan));
            }
            if (colSpan > 1) {
                attrList.setAttribute(XHTML_NAMESPACE, "colspan", String.valueOf(colSpan));
            }
            ElementAlignment verticalAlignment = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            attrList.setAttribute(XHTML_NAMESPACE, "valign", this.translateVerticalAlignment(verticalAlignment));
        }
        if (background != null && content != null) {
            attrs = new ReportAttributeMap(background.getAttributes());
            attrs.putAll(content);
            HtmlTagHelper.applyHtmlAttributes(attrs, attrList);
        } else if (background != null) {
            attrs = background.getAttributes();
            HtmlTagHelper.applyHtmlAttributes(attrs, attrList);
        } else if (content != null) {
            HtmlTagHelper.applyHtmlAttributes(content, attrList);
        }
        this.styleManager.updateStyle(styleBuilder, attrList);
        return attrList;
    }

    private String translateVerticalAlignment(ElementAlignment ea) {
        if (ElementAlignment.BOTTOM.equals(ea)) {
            return "bottom";
        }
        if (ElementAlignment.MIDDLE.equals(ea)) {
            return "middle";
        }
        return "top";
    }

    public AttributeList createRowAttributes(double rowHeight, HtmlRowBackgroundStruct struct) {
        AttributeList attrList = new AttributeList();
        StyleBuilder styleBuilder = this.getStyleBuilder();
        StyleBuilderFactory styleBuilderFactory = this.getStyleBuilderFactory();
        if (this.isTableRowBorderDefinition()) {
            styleBuilder.clear();
            if (!struct.isFailed()) {
                Color commonBackgroundColor = struct.getColor();
                BorderEdge top = struct.getTopEdge();
                BorderEdge bottom = struct.getBottomEdge();
                if (commonBackgroundColor != null) {
                    styleBuilder.append(StyleBuilder.CSSKeys.BACKGROUND_COLOR, HtmlColors.getColorString(commonBackgroundColor));
                }
                if (!BorderEdge.EMPTY.equals(top)) {
                    styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_TOP, styleBuilder.printEdgeAsCSS(top));
                }
                if (!BorderEdge.EMPTY.equals(bottom)) {
                    styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_BOTTOM, styleBuilder.printEdgeAsCSS(bottom));
                }
            }
            styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, styleBuilder.getPointConverter().format(styleBuilderFactory.fixLengthForSafari(rowHeight)), "pt");
            this.styleManager.updateStyle(styleBuilder, attrList);
        } else {
            attrList.setAttribute(XHTML_NAMESPACE, "style", "height: " + styleBuilder.getPointConverter().format(styleBuilderFactory.fixLengthForSafari(rowHeight)) + "pt");
        }
        return attrList;
    }

    public AttributeList createSheetNameAttributes() {
        AttributeList tableAttrList = new AttributeList();
        String additionalStyleClass = this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.SheetNameClass");
        if (additionalStyleClass != null) {
            tableAttrList.setAttribute(XHTML_NAMESPACE, "class", additionalStyleClass);
        }
        return tableAttrList;
    }

    protected boolean isProportionalColumnWidths() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ProportionalColumnWidths", "false"));
    }

    public boolean isEmptyCellsUseCSS() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.EmptyCellsUseCSS", "false"));
    }

    public AttributeList createTableAttributes(SlimSheetLayout sheetLayout, ReportAttributeMap attr) {
        StyleBuilder styleBuilder = this.getStyleBuilder();
        int noc = sheetLayout.getColumnCount();
        styleBuilder.clear();
        if (noc > 0 && !this.isProportionalColumnWidths()) {
            int width = (int)StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(0, noc));
            styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, width + "pt");
        } else {
            styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, "100%");
        }
        if (this.isTableRowBorderDefinition()) {
            styleBuilder.append(StyleBuilder.CSSKeys.BORDER_COLLAPSE, "collapse");
        }
        if (this.isEmptyCellsUseCSS()) {
            styleBuilder.append(StyleBuilder.CSSKeys.EMPTY_CELLS, "show");
        }
        if (this.isUseTableLayoutFixed()) {
            styleBuilder.append(StyleBuilder.CSSKeys.TABLE_LAYOUT, "fixed");
        }
        String additionalStyleClass = this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.StyleClass");
        AttributeList tableAttrList = new AttributeList();
        if (additionalStyleClass != null) {
            tableAttrList.setAttribute(XHTML_NAMESPACE, "class", additionalStyleClass);
        }
        tableAttrList.setAttribute(XHTML_NAMESPACE, "cellspacing", "0");
        tableAttrList.setAttribute(XHTML_NAMESPACE, "cellpadding", "0");
        HtmlTagHelper.applyHtmlAttributes(attr, tableAttrList);
        this.styleManager.updateStyle(styleBuilder, tableAttrList);
        return tableAttrList;
    }

    public static void applyHtmlAttributes(ReportAttributeMap attributes, AttributeList attrList) {
        Object title;
        Object onMouseEnter;
        Object onMouseOut;
        Object onMouseUp;
        Object onMouseOver;
        Object onMouseMove;
        Object onMouseDown;
        Object onKeyUp;
        Object onKeyPressed;
        Object onKeyDown;
        Object onDblClick;
        Object onClick;
        Object styleClass;
        Object id;
        if (attributes == null) {
            throw new NullPointerException("Attributes must not be null");
        }
        if (attrList == null) {
            throw new NullPointerException();
        }
        Object name = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "name");
        if (name != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "name", String.valueOf(name));
        }
        if ((id = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "xml-id")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "id", String.valueOf(id));
        }
        if ((styleClass = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "class")) != null) {
            String styleClassAttr = attrList.getAttribute(XHTML_NAMESPACE, "class");
            if (styleClassAttr == null) {
                attrList.setAttribute(XHTML_NAMESPACE, "class", String.valueOf(styleClass));
            } else {
                attrList.setAttribute(XHTML_NAMESPACE, "class", styleClassAttr + ' ' + String.valueOf(styleClass));
            }
        }
        if ((onClick = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onclick")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onclick", String.valueOf(onClick));
        }
        if ((onDblClick = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "ondblclick")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "ondblclick", String.valueOf(onDblClick));
        }
        if ((onKeyDown = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onkeydown")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onkeydown", String.valueOf(onKeyDown));
        }
        if ((onKeyPressed = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onkeypressed")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onkeypressed", String.valueOf(onKeyPressed));
        }
        if ((onKeyUp = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onkeyup")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onkeyup", String.valueOf(onKeyUp));
        }
        if ((onMouseDown = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmousedown")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmousedown", String.valueOf(onMouseDown));
        }
        if ((onMouseMove = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmousemove")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmousemove", String.valueOf(onMouseMove));
        }
        if ((onMouseOver = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmouseover")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmouseover", String.valueOf(onMouseOver));
        }
        if ((onMouseUp = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmouseup")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmouseup", String.valueOf(onMouseUp));
        }
        if ((onMouseOut = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmouseout")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmouseout", String.valueOf(onMouseOut));
        }
        if ((onMouseEnter = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmouseenter")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmouseenter", String.valueOf(onMouseEnter));
        }
        if ((title = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "title")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "title", String.valueOf(title));
        }
    }

    private boolean isUseTableLayoutFixed() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.UseTableLayoutFixed", "true"));
    }

    private boolean isTableRowBorderDefinition() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.TableRowBorderDefinition", "false"));
    }
}

