/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlOutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class PageableHtmlOutputProcessor
extends AbstractTableOutputProcessor
implements PageableOutputProcessor,
HtmlOutputProcessor {
    private List<PhysicalPageKey> physicalPages;
    private HtmlOutputProcessorMetaData metaData;
    private HtmlPrinter printer;
    private FlowSelector flowSelector;

    public PageableHtmlOutputProcessor(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.physicalPages = new ArrayList<PhysicalPageKey>();
        this.flowSelector = new DisplayAllFlowSelector();
        this.metaData = new HtmlOutputProcessorMetaData(2);
    }

    @Override
    protected void processingPagesFinished() {
        super.processingPagesFinished();
        this.physicalPages = Collections.unmodifiableList(this.physicalPages);
    }

    @Override
    public int getPhysicalPageCount() {
        return this.physicalPages.size();
    }

    @Override
    public PhysicalPageKey getPhysicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return this.physicalPages.get(page);
    }

    @Override
    protected LogicalPageKey createLogicalPage(int width, int height) {
        LogicalPageKey key = super.createLogicalPage(width, height);
        for (int h = 0; h < key.getHeight(); ++h) {
            for (int w = 0; w < key.getWidth(); ++w) {
                this.physicalPages.add(key.getPage(w, h));
            }
        }
        return key;
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public HtmlPrinter getPrinter() {
        return this.printer;
    }

    @Override
    public void setPrinter(HtmlPrinter printer) {
        this.printer = printer;
    }

    @Override
    public FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(FlowSelector flowSelector) {
        this.flowSelector = flowSelector;
    }

    @Override
    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        if (this.printer == null) {
            return;
        }
        this.printer.print(logicalPageKey, logicalPage, contentProducer, this.metaData, false);
    }

    @Override
    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        this.metaData.commit();
    }
}

