/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal;

import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfWriter;

public class PolygonAnnotation
extends PdfAnnotation {
    private static final PdfName POLYGON = new PdfName("Polygon");
    private static final PdfName VERTICES = new PdfName("Vertices");

    public PolygonAnnotation(PdfWriter writer, float[] coords) {
        super(writer, null);
        this.put(PdfName.SUBTYPE, (PdfObject)POLYGON);
        this.put(PdfName.RECT, (PdfObject)PolygonAnnotation.createRec(coords));
        this.put(VERTICES, (PdfObject)new PdfArray(coords));
    }

    private static PdfRectangle createRec(float[] coords) {
        float minX = 2.1474836E9f;
        float maxX = -2.1474836E9f;
        float minY = 2.1474836E9f;
        float maxY = -2.1474836E9f;
        for (int i = 0; i < coords.length; i += 2) {
            float x = coords[i];
            float y = coords[i + 1];
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        return new PdfRectangle(minX, minY, maxX, maxY);
    }
}

