/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence;

import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.PrinterName;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.AbstractSequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.PrinterNamesSequenceDescription;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;

public class PrinterNamesSequence
extends AbstractSequence {
    @Override
    public SequenceDescription getSequenceDescription() {
        return new PrinterNamesSequenceDescription();
    }

    @Override
    public TableModel produce(DataRow parameters, DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        TypedTableModel tt = new TypedTableModel();
        tt.addColumn("Printer ID", String.class);
        tt.addColumn("Printer Name", String.class);
        for (int i = 0; i < services.length; ++i) {
            PrintService service = services[i];
            PrinterName displayName = service.getAttribute(PrinterName.class);
            if (displayName != null) {
                tt.addRow(service.getName(), displayName.getValue());
                continue;
            }
            tt.addRow(service.getName(), service.getName());
        }
        return tt;
    }
}

