/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence;

import java.beans.PropertyEditor;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.Sequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class AbstractSequenceDescription
implements SequenceDescription {
    private String bundleName;
    private Class<? extends Sequence> baseClass;

    public AbstractSequenceDescription(String bundleName, Class<? extends Sequence> baseClass) {
        this.bundleName = bundleName;
        this.baseClass = baseClass;
    }

    protected ResourceBundle getBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.bundleName, locale);
        }
        catch (MissingResourceException mre) {
            return ResourceBundle.getBundle(this.bundleName, Locale.ENGLISH);
        }
    }

    @Override
    public int getParameterCount() {
        try {
            String string = this.getBundle(Locale.getDefault()).getString("parameter-count");
            return Integer.parseInt(string);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getParameterName(int position) {
        return this.getBundle(Locale.getDefault()).getString("parameter." + position + ".name");
    }

    @Override
    public String getParameterDisplayName(int position, Locale locale) {
        return this.getBundle(locale).getString("parameter." + position + ".display-name");
    }

    @Override
    public String getParameterDescription(int position, Locale locale) {
        return this.getBundle(locale).getString("parameter." + position + ".description");
    }

    @Override
    public Class getParameterType(int position) {
        try {
            String string = this.getBundle(Locale.getDefault()).getString("parameter." + position + ".type");
            return Class.forName(string, false, ObjectUtilities.getClassLoader(AbstractSequenceDescription.class));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getParameterRole(int position, Locale locale) {
        try {
            return this.getBundle(Locale.getDefault()).getString("parameter." + position + ".role");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getParameterDefault(int position) {
        try {
            String value = this.getBundle(Locale.getDefault()).getString("parameter." + position + ".default-value");
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return ConverterRegistry.toPropertyValue(value, this.getParameterType(position));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getDisplayName(Locale locale) {
        try {
            return this.getBundle(Locale.getDefault()).getString("display-name");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getDescription(Locale locale) {
        try {
            return this.getBundle(Locale.getDefault()).getString("description");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public PropertyEditor getEditor(int position) {
        try {
            ResourceBundle bundle = this.getBundle(Locale.getDefault());
            String key = "parameter." + position + ".editor";
            if (!bundle.containsKey(key)) {
                return null;
            }
            String string = bundle.getString(key);
            return (PropertyEditor)ObjectUtilities.loadAndInstantiate((String)string, AbstractSequenceDescription.class, PropertyEditor.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getSequenceGroup(Locale locale) {
        try {
            return this.getBundle(Locale.getDefault()).getString("group");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Sequence newInstance() {
        try {
            return this.baseClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractSequenceDescription");
        sb.append("{baseClass=").append(this.baseClass);
        sb.append('}');
        return sb.toString();
    }
}

