/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.util.ImageUtils;

public class ZoomAction
extends AbstractAction {
    private double zoom;
    private PreviewPane previewPane;
    private PaginatedListener paginatedListener;

    public ZoomAction(double zoom, PreviewPane previewPane) {
        this.zoom = zoom;
        this.previewPane = previewPane;
        this.putValue("Name", NumberFormat.getPercentInstance(previewPane.getLocale()).format(zoom));
        this.putValue("SmallIcon", ImageUtils.createTransparentIcon(16, 16));
        this.putValue("Icon24", ImageUtils.createTransparentIcon(24, 24));
        this.paginatedListener = new PaginatedListener();
        this.previewPane.addPropertyChangeListener("paginated", this.paginatedListener);
        this.setEnabled(previewPane.getReportJob() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.previewPane.setZoom(this.zoom);
    }

    public void deinitialize() {
        this.previewPane.removePropertyChangeListener("paginated", this.paginatedListener);
        this.previewPane = null;
    }

    private class PaginatedListener
    implements PropertyChangeListener {
        protected PaginatedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ZoomAction.this.setEnabled(ZoomAction.this.previewPane.isPaginated());
        }
    }
}

