/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.metadata.ReportProcessTaskRegistry;

public class ReportProcessTaskPropertyEditor
implements PropertyEditor {
    private String value;
    private PropertyChangeSupport propertyChangeSupport;
    private ArrayList validValues = new ArrayList();

    public ReportProcessTaskPropertyEditor() {
        Object[] types = ReportProcessTaskRegistry.getInstance().getExportTypes();
        Arrays.sort(types);
        for (int i = 0; i < types.length; ++i) {
            Object type = types[i];
            this.validValues.add(type);
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public void setValue(Object value) {
        String oldValue = this.value;
        this.value = this.validValues.contains(value) ? (String)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return this.value;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    @Override
    public String[] getTags() {
        return this.validValues.toArray(new String[this.validValues.size()]);
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

