/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.util.StrokeUtility;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class BasicStrokeEditor
implements PropertyEditor {
    private BasicStroke value = new BasicStroke();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setValue(Object value) {
        BasicStroke oldValue = this.value;
        this.value = value instanceof BasicStroke ? (BasicStroke)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return "";
        }
        BorderStyle borderStyle = StrokeUtility.translateStrokeStyle(this.value);
        float width = this.value.getLineWidth();
        return borderStyle + ", " + width;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String[] strings = StringUtils.split((String)text, (String)",");
        if (strings.length == 0) {
            this.setValue(null);
            return;
        }
        if (strings.length == 1) {
            float v = ParserUtil.parseFloat((String)strings[0].trim(), (float)-1.0f);
            if (v < 0.0f) {
                this.setValue(BorderStyle.getBorderStyle(strings[0].trim()));
                return;
            }
            this.setValue(new BasicStroke(v));
            return;
        }
        if (strings.length > 2) {
            return;
        }
        float width = ParserUtil.parseFloat((String)strings[0].trim(), (float)-1.0f);
        if (width < 0.0f) {
            width = ParserUtil.parseFloat((String)strings[1].trim(), (float)-1.0f);
        }
        if (width < 0.0f) {
            this.setValue(null);
            return;
        }
        BorderStyle style = BorderStyle.getBorderStyle(strings[0].trim());
        if (style == null) {
            style = BorderStyle.getBorderStyle(strings[1].trim());
        }
        if (style == null) {
            this.setValue(null);
        } else {
            this.setValue(style.createStroke(width));
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new StrokeEditorComponent(this);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        if (gfx instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)gfx;
            graphics2D.setStroke(this.value);
            graphics2D.drawLine(box.x, box.height / 2 + box.y, box.x + box.width, box.height / 2 + box.y);
        }
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    private static class StrokeIcon
    implements Icon {
        private Stroke basicStroke;

        private StrokeIcon(Stroke basicStroke) {
            this.basicStroke = basicStroke;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            Color origColor = g2d.getColor();
            Object hint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Stroke origStroke = g2d.getStroke();
            g2d.translate(x, y);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(this.basicStroke);
            g2d.drawLine(0, this.getIconHeight() / 2, this.getIconWidth(), this.getIconHeight() / 2);
            g2d.setColor(origColor);
            g2d.translate(-x, -y);
            g2d.setStroke(origStroke);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }

        @Override
        public int getIconWidth() {
            return 100;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }

    private static class SamplePanel
    extends JPanel {
        private Stroke sampleValue;

        public SamplePanel() {
            this.setBorder(BorderFactory.createTitledBorder("Sample"));
            this.setMinimumSize(new Dimension(40, 40));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.sampleValue != null) {
                Graphics2D g2d = (Graphics2D)g;
                Stroke origStroke = g2d.getStroke();
                Color origColor = g2d.getColor();
                Shape origClip = g2d.getClip();
                g2d.setStroke(this.sampleValue);
                g2d.drawLine(this.getInsets().left + 1, this.getHeight() / 2 + 1, this.getWidth() - (this.getInsets().right + 1), this.getHeight() / 2 + 1);
                g2d.setClip(origClip);
                g2d.setStroke(origStroke);
                g2d.setColor(origColor);
            }
        }

        public Stroke getSampleValue() {
            return this.sampleValue;
        }

        public void setSampleValue(Stroke sampleValue) {
            this.sampleValue = sampleValue;
            this.repaint();
        }
    }

    private static class StrokeEditorComponent
    extends JPanel {
        private float width;
        private BorderStyle borderStyle;
        private SamplePanel samplePanel;
        private BasicStrokeEditor editor;

        public StrokeEditorComponent(BasicStrokeEditor editor) {
            this.editor = editor;
            this.samplePanel = new SamplePanel();
            BasicStroke vb = (BasicStroke)editor.getValue();
            if (vb != null) {
                this.width = vb.getLineWidth();
                this.borderStyle = StrokeUtility.translateStrokeStyle(vb);
            } else {
                this.width = 0.0f;
                this.borderStyle = BorderStyle.NONE;
            }
            this.initGUI();
        }

        public void setStrokeWidth(float width) {
            if (this.width == width) {
                return;
            }
            this.width = width;
            if (this.borderStyle == null || this.borderStyle == BorderStyle.NONE) {
                this.editor.setValue(null);
                this.samplePanel.setSampleValue(null);
            } else {
                Stroke stroke = this.borderStyle.createStroke(width);
                this.editor.setValue(stroke);
                this.samplePanel.setSampleValue(stroke);
            }
        }

        public void setDashType(BorderStyle type) {
            if (this.borderStyle == type) {
                return;
            }
            this.borderStyle = type;
            if (this.borderStyle == null || this.borderStyle == BorderStyle.NONE) {
                this.editor.setValue(null);
                this.samplePanel.setSampleValue(null);
            } else {
                Stroke stroke = this.borderStyle.createStroke(this.width);
                this.editor.setValue(stroke);
                this.samplePanel.setSampleValue(stroke);
            }
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 13;
            this.add((Component)new JLabel("Width:"), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.anchor = 17;
            JTextField strokeWidthField = new JTextField();
            strokeWidthField.getDocument().addDocumentListener(new WidthUpdateHandler(strokeWidthField));
            strokeWidthField.setText(String.valueOf(this.width));
            strokeWidthField.setColumns(6);
            this.add((Component)strokeWidthField, constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = 10;
            this.add((Component)new JLabel("Dashes:"), constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            JComboBox<Object> dashComboBox = new JComboBox<Object>(new Object[]{BorderStyle.SOLID, BorderStyle.DASHED, BorderStyle.DOTTED, BorderStyle.DOT_DASH, BorderStyle.DOT_DOT_DASH});
            dashComboBox.setRenderer(new BorderStyleRenderer());
            dashComboBox.setSelectedItem(this.borderStyle);
            dashComboBox.addActionListener(new DashSelectionHandler(dashComboBox));
            this.add(dashComboBox, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            this.add((Component)this.samplePanel, constraints);
        }

        private class WidthUpdateHandler
        implements DocumentListener {
            private JTextField textField;

            public WidthUpdateHandler(JTextField textField) {
                this.textField = textField;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                String s = this.textField.getText();
                try {
                    StrokeEditorComponent.this.setStrokeWidth(Float.parseFloat(s.trim()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }
        }

        private class DashSelectionHandler
        implements ActionListener {
            private final JComboBox dashComboBox;

            public DashSelectionHandler(JComboBox dashComboBox) {
                this.dashComboBox = dashComboBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                StrokeEditorComponent.this.setDashType((BorderStyle)this.dashComboBox.getSelectedItem());
            }
        }
    }

    private static class BorderStyleRenderer
    extends DefaultListCellRenderer {
        private BorderStyleRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof BorderStyle) {
                BorderStyle style = (BorderStyle)value;
                StrokeIcon strokeIcon = new StrokeIcon(style.createStroke(2.0f));
                label.setIcon(strokeIcon);
            } else {
                label.setIcon(null);
            }
            label.setText("");
            return label;
        }
    }
}

