/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ReportPreProcessorMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ReportPreProcessorPropertyReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportPreProcessorReadHandler
extends AbstractMetaDataReadHandler {
    private final ReportPreProcessorMetaDataBuilder builder;
    private ArrayList<ReportPreProcessorPropertyReadHandler> attributeHandlers = new ArrayList();
    private SharedBeanInfo beanInfo;

    public ReportPreProcessorReadHandler() {
        this.builder = new ReportPreProcessorMetaDataBuilder();
    }

    public ReportPreProcessorMetaDataBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected boolean isDerivedName() {
        return true;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.getBuilder().autoProcess("true".equals(attrs.getValue(this.getUri(), "auto-process")));
        this.getBuilder().priority(ParserUtil.parseInt((String)attrs.getValue(this.getUri(), "priority"), (int)0));
        this.getBuilder().designMode("true".equals(attrs.getValue(this.getUri(), "execute-in-design-mode")));
        this.getBuilder().impl(this.parseImpl(attrs));
        this.getBuilder().bundle(this.getBundle(), "");
        this.beanInfo = new SharedBeanInfo(this.getBuilder().getImpl());
    }

    private Class<? extends ReportPreProcessor> parseImpl(Attributes attrs) throws ParseException {
        Class expressionClass;
        String valueTypeText = attrs.getValue(this.getUri(), "class");
        if (valueTypeText == null) {
            throw new ParseException("Attribute 'class' is undefined", this.getLocator());
        }
        try {
            expressionClass = ObjectUtilities.loadAndValidate((String)valueTypeText, ReportPreProcessorReadHandler.class, ReportPreProcessor.class);
            if (!ReportPreProcessor.class.isAssignableFrom(expressionClass)) {
                throw new ParseException("Attribute 'class' is not valid", this.getLocator());
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'class' is not valid", e, this.getLocator());
        }
        return expressionClass;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            ReportPreProcessorPropertyReadHandler readHandler = new ReportPreProcessorPropertyReadHandler(this.beanInfo, this.getBundle());
            this.attributeHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.attributeHandlers.size(); ++i) {
            ReportPreProcessorPropertyReadHandler handler = this.attributeHandlers.get(i);
            this.getBuilder().property(handler.getObject());
        }
    }

    public Object getObject() throws SAXException {
        return new DefaultReportPreProcessorMetaData(this.getBuilder());
    }
}

