/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.FilteringPageBreakPositions;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositions;
import org.pentaho.reporting.engine.classic.core.layout.process.util.BasePaginationTableState;

public class PaginationTableState
implements BasePaginationTableState {
    private PaginationTableState parent;
    private boolean suspended;
    private long pageOffset;
    private long pageHeight;
    private long pageEnd;
    private PageBreakPositions breakPositions;
    private boolean fixedPositionProcessingSuspended;
    private boolean tableProcessing;

    public PaginationTableState(long pageHeight, long pageOffset, long pageEnd, PageBreakPositions breakPositions) {
        this.pageHeight = pageHeight;
        this.pageOffset = pageOffset;
        this.pageEnd = pageEnd;
        this.breakPositions = breakPositions;
    }

    public PaginationTableState(PaginationTableState parent) {
        this.parent = parent;
        this.pageOffset = parent.pageOffset;
        this.breakPositions = parent.breakPositions;
        this.pageHeight = parent.pageHeight;
        this.pageEnd = parent.pageEnd;
        this.fixedPositionProcessingSuspended = true;
        this.tableProcessing = parent.tableProcessing;
    }

    public void suspendVisualStateCollection(boolean temporary) {
        this.suspended = true;
        if (!temporary && this.parent != null) {
            this.parent.suspendVisualStateCollection(temporary);
        }
    }

    @Override
    public boolean isTableProcessing() {
        return this.tableProcessing;
    }

    @Override
    public long getPageOffset() {
        return this.pageOffset;
    }

    public PageBreakPositions getBreakPositions() {
        return this.breakPositions;
    }

    public long getPageHeight() {
        return this.pageHeight;
    }

    public long getPageEnd() {
        return this.pageEnd;
    }

    public boolean isVisualStateCollectionSuspended() {
        return this.suspended;
    }

    public PaginationTableState pop() {
        return this.parent;
    }

    public boolean isFixedPositionProcessingSuspended() {
        return this.fixedPositionProcessingSuspended;
    }

    public void defineArtificialPageStart(long offset) {
        this.breakPositions = new FilteringPageBreakPositions(this.breakPositions, offset);
        this.pageOffset = offset;
        this.tableProcessing = true;
    }

    @Override
    public boolean isOnPageStart(long offset) {
        return this.breakPositions.isPageStart(offset);
    }

    @Override
    public long getPageOffset(long position) {
        return this.breakPositions.findPreviousBreakPosition(position);
    }
}

