/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowModel;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.CacheBoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;

public class TableRowHeightApplyStep
extends IterateStructuralProcessStep {
    private BoxContextPool pool = new BoxContextPool();
    private BoxContext context;
    private TableRowModel rowModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long start(TableSectionRenderBox section) {
        try {
            this.context = this.pool.get(null, section);
            this.rowModel = section.getRowModel();
            this.processBoxChilds(section);
            long usedTableBodyHeight = this.context.getBoxCursor() - this.context.boxContextStart;
            section.setCachedHeight(usedTableBodyHeight);
            long l = usedTableBodyHeight;
            return l;
        }
        finally {
            this.context = this.context.pop();
            this.rowModel = null;
        }
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        node.setCachedY(this.context.getBoxCursor());
        this.context.addBoxCursor(node.getCachedHeight());
    }

    private void shiftBox(RenderBox box) {
        long oldPosition = box.getCachedY();
        long position = this.context.getBoxCursor();
        long shift = position - oldPosition;
        if (shift < 0L) {
            throw new IllegalStateException(String.format("Shift-back is not allowed: shift=%d: old=%d -> new=%d (%s)", shift, oldPosition, position, box));
        }
        CacheBoxShifter.shiftBox(box, shift);
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        this.shiftBox(box);
        this.context = this.pool.get(this.context, box);
        return false;
    }

    @Override
    protected void finishTableRowBox(TableRowRenderBox box) {
        long validatedRowHeight = this.rowModel.getValidatedRowSize(box.getRowIndex());
        box.setCachedHeight(validatedRowHeight);
        this.context.addBoxCursor(validatedRowHeight);
        this.context = this.context.pop();
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        this.shiftBox(box);
        this.context = this.pool.get(this.context, box);
        return true;
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        this.context = this.context.pop();
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        this.shiftBox(box);
        this.context = this.pool.get(this.context, box);
        return true;
    }

    @Override
    protected void finishBlockBox(BlockRenderBox box) {
        this.context = this.context.pop();
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        this.shiftBox(box);
        this.context = this.pool.get(this.context, box);
        return true;
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        RenderNode firstChild = box.getFirstChild();
        if (firstChild != null) {
            RenderNode lastChild = box.getLastChild();
            long height = lastChild.getCachedY2() - firstChild.getCachedY();
            box.setCachedHeight(height);
        }
        this.context = this.context.pop();
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        return false;
    }

    @Override
    protected void finishOtherBox(RenderBox box) {
        RenderNode firstChild = box.getFirstChild();
        if (firstChild != null) {
            RenderNode lastChild = box.getLastChild();
            long height = lastChild.getCachedY2() - firstChild.getCachedY();
            box.setCachedHeight(height);
        }
    }

    private class BoxContextPool
    extends StackedObjectPool<BoxContext> {
        private BoxContextPool() {
        }

        @Override
        protected BoxContext create() {
            return new BoxContext();
        }

        public BoxContext get(BoxContext parent, RenderBox box) {
            BoxContext boxContext = (BoxContext)super.get();
            boxContext.reuse(this, parent, box);
            return boxContext;
        }
    }

    private static class BoxContext {
        private BoxContextPool pool;
        private BoxContext parent;
        private long boxContextStart;
        private long boxCursor;

        private BoxContext() {
        }

        public void reuse(BoxContextPool pool, BoxContext parent, RenderBox box) {
            this.pool = pool;
            this.parent = parent;
            this.boxCursor = this.boxContextStart = box.getCachedY();
        }

        public BoxContext pop() {
            if (this.parent != null) {
                this.parent.boxCursor = this.boxCursor;
            }
            this.pool.free(this);
            return this.parent;
        }

        public long getBoxCursor() {
            return this.boxCursor;
        }

        public void addBoxCursor(long height) {
            this.boxCursor += height;
        }
    }
}

