/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.AutoRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableHelper;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.SeparateRowModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowModel;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class TableSectionRenderBox
extends BlockRenderBox {
    private static final int FLAG_TABLE_SECTION_STRUCTURE_VALIDATED = 524288;
    private static final int FLAG_TABLE_SECTION_ACTIVE = 0x4000000;
    private static final int FLAG_TABLE_SECTION_MARKED_ACTIVE = 0x1000000;
    private static final int FLAG_TABLE_SECTION_APPLIED_ACTIVE = 0x2000000;
    private Role displayRole;
    private TableRowModel rowModel = new SeparateRowModel();
    private HashMap<Long, Long> headerShift;
    private HashMap<Long, Long> markedHeaderShift;
    private HashMap<Long, Long> appliedHeaderShift;
    private long rowModelAge;

    public TableSectionRenderBox() {
        this(SimpleStyleSheet.EMPTY_STYLE, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, null);
    }

    public TableSectionRenderBox(StyleSheet styleSheet, InstanceID instanceID, BoxDefinition boxDefinition, ElementType elementType, ReportAttributeMap attributes, ReportStateKey stateKey) {
        super(styleSheet, instanceID, boxDefinition, elementType, attributes, stateKey);
        this.rowModel.setDebugInformation(elementType, instanceID);
        this.appliedHeaderShift = new HashMap();
        this.markedHeaderShift = new HashMap();
        this.headerShift = new HashMap();
        Object layoutMode = styleSheet.getStyleProperty(BandStyleKeys.LAYOUT);
        this.displayRole = "table-footer".equals(layoutMode) ? Role.FOOTER : ("table-header".equals(layoutMode) ? Role.HEADER : Role.BODY);
    }

    public long getRowModelAge() {
        return this.rowModelAge;
    }

    public void setRowModelAge(long rowModelAge) {
        this.rowModelAge = rowModelAge;
    }

    @Override
    public boolean useMinimumChunkWidth() {
        return true;
    }

    public long getHeaderShift(long pageOffset) {
        Long retval = this.headerShift.get(pageOffset);
        if (retval == null) {
            return 0L;
        }
        return retval;
    }

    public void setHeaderShift(long pageOffset, long headerShift) {
        this.headerShift.put(pageOffset, headerShift);
    }

    @Override
    public Object clone() {
        TableSectionRenderBox clone = (TableSectionRenderBox)super.clone();
        clone.headerShift = (HashMap)this.headerShift.clone();
        return clone;
    }

    public boolean isBody() {
        return Role.BODY.equals((Object)this.displayRole);
    }

    public Role getDisplayRole() {
        return this.displayRole;
    }

    @Override
    public int getNodeType() {
        return 270338;
    }

    public TableColumnModel getColumnModel() {
        TableRenderBox table = TableHelper.lookupTable(this);
        if (table == null) {
            return null;
        }
        return table.getColumnModel();
    }

    public TableRowModel getRowModel() {
        return this.rowModel;
    }

    public boolean isStructureValidated() {
        return this.isFlag(524288);
    }

    public void setStructureValidated(boolean structureValidated) {
        this.setFlag(524288, structureValidated);
    }

    public boolean isActive() {
        return this.isFlag(0x4000000);
    }

    protected void setActive(boolean active) {
        this.setFlag(0x4000000, active);
    }

    public boolean isMarkedActive() {
        return this.isFlag(0x1000000);
    }

    protected void setMarkedActive(boolean active) {
        this.setFlag(0x1000000, active);
    }

    public boolean isAppliedActive() {
        return this.isFlag(0x2000000);
    }

    protected void setAppliedActive(boolean active) {
        this.setFlag(0x2000000, active);
    }

    @Override
    public void markBoxSeen() {
        super.markBoxSeen();
        this.setMarkedActive(this.isActive());
        this.markedHeaderShift = (HashMap)this.headerShift.clone();
    }

    @Override
    public void commit() {
        super.commit();
        this.appliedHeaderShift = (HashMap)this.markedHeaderShift.clone();
        this.setAppliedActive(this.isMarkedActive());
    }

    @Override
    public void rollback(boolean deepDirty) {
        super.rollback(deepDirty);
        this.setActive(this.isAppliedActive());
        this.headerShift = (HashMap)this.appliedHeaderShift.clone();
    }

    @Override
    public void addChild(RenderNode child) {
        if (!this.isValid(child)) {
            TableRowRenderBox tsrb = new TableRowRenderBox();
            tsrb.addChild(child);
            this.addChild(tsrb);
            tsrb.close();
            return;
        }
        super.addChild(child);
    }

    private boolean isValid(RenderNode child) {
        if ((child.getNodeType() & 2) != 2) {
            return true;
        }
        if (child.getNodeType() == 524290) {
            return true;
        }
        if (child.getNodeType() == 530) {
            return true;
        }
        if (child.getNodeType() == 0x1000012) {
            return true;
        }
        return child.getNodeType() == 278530;
    }

    @Override
    public RenderBox create(StyleSheet styleSheet) {
        return new AutoRenderBox(styleSheet);
    }

    public static enum Role {
        BODY,
        HEADER,
        FOOTER;

    }
}

