/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;

public class SheetNameFunction
extends AbstractElementFormatFunction
implements StructureFunction {
    private static final Log logger = LogFactory.getLog(SheetNameFunction.class);
    private static final String DECALRED_SHEETNAME_FUNCTION_KEY = "org.pentaho.reporting.engine.classic.core.targets.table.TableWriter.SheetNameFunction";
    private transient String lastValue;
    private transient String functionToCall;

    @Override
    public void reportInitialized(ReportEvent event) {
        this.functionToCall = this.getReportConfiguration().getConfigProperty(DECALRED_SHEETNAME_FUNCTION_KEY);
        super.reportInitialized(event);
    }

    @Override
    public int getProcessingPriority() {
        return 3000;
    }

    @Override
    protected boolean isExecutable() {
        if (this.functionToCall == null) {
            return false;
        }
        return this.getRuntime().getExportDescriptor().startsWith("table/");
    }

    @Override
    protected boolean evaluateElement(ReportElement e) {
        this.lastValue = null;
        Object value = this.getDataRow().get(this.functionToCall);
        if (value != null) {
            this.lastValue = value.toString();
            e.getStyle().setStyleProperty(BandStyleKeys.COMPUTED_SHEETNAME, this.lastValue);
        }
        return true;
    }

    @Override
    public Object getValue() {
        return this.lastValue;
    }
}

