/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.formula;

import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.URLEncoder;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class ParameterTextFunction
implements Function {
    private static final Log logger = LogFactory.getLog(ParameterTextFunction.class);

    public String getCanonicalName() {
        return "PARAMETERTEXT";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        String encodingResult;
        String s;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 3) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Object rawValue = parameters.getValue(0);
        if (rawValue == null) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        try {
            s = ConverterRegistry.toAttributeValue(rawValue);
        }
        catch (BeanException e) {
            logger.warn((Object)("PARAMETERTEXT: Failed to convert value " + rawValue + " (" + rawValue.getClass() + ")"), (Throwable)e);
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        if (s == null) {
            return new TypeValuePair((Type)TextType.TYPE, (Object)"");
        }
        if (parameterCount > 1) {
            Boolean urlEncode = context.getTypeRegistry().convertToLogical(parameters.getType(1), parameters.getValue(1));
            if (Boolean.FALSE.equals(urlEncode)) {
                return new TypeValuePair((Type)TextType.TYPE, (Object)s);
            }
            if (parameterCount == 3) {
                Type encodingType = parameters.getType(2);
                Object encodingValue = parameters.getValue(2);
                encodingResult = context.getTypeRegistry().convertToText(encodingType, encodingValue);
                if (encodingResult == null) {
                    throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
                }
            } else {
                encodingResult = context.getConfiguration().getConfigProperty("org.pentaho.reporting.libraries.formula.URLEncoding", "UTF-8");
            }
        } else {
            encodingResult = context.getConfiguration().getConfigProperty("org.pentaho.reporting.libraries.formula.URLEncoding", "UTF-8");
        }
        try {
            return new TypeValuePair((Type)TextType.TYPE, (Object)URLEncoder.encode((String)s, (String)encodingResult));
        }
        catch (UnsupportedEncodingException use) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
    }
}

