/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.TotalGroupSumFunction;

public class TotalGroupSumQuotientFunction
extends AbstractFunction {
    private TotalGroupSumFunction dividendFunction = new TotalGroupSumFunction();
    private TotalGroupSumFunction divisorFunction = new TotalGroupSumFunction();
    private int scale = 14;
    private int roundingMode = 4;

    @Override
    public void reportInitialized(ReportEvent event) {
        this.dividendFunction.reportInitialized(event);
        this.divisorFunction.reportInitialized(event);
    }

    @Override
    public void groupStarted(ReportEvent event) {
        this.dividendFunction.groupStarted(event);
        this.divisorFunction.groupStarted(event);
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        this.dividendFunction.itemsAdvanced(event);
        this.divisorFunction.itemsAdvanced(event);
    }

    public String getGroup() {
        return this.divisorFunction.getGroup();
    }

    public void setGroup(String group) {
        this.divisorFunction.setGroup(group);
        this.dividendFunction.setGroup(group);
    }

    @Override
    public Object getValue() {
        BigDecimal dividend = (BigDecimal)this.dividendFunction.getValue();
        BigDecimal divisor = (BigDecimal)this.divisorFunction.getValue();
        if (divisor == null || dividend == null || divisor.doubleValue() == 0.0) {
            return null;
        }
        return dividend.divide(divisor, this.scale, this.roundingMode);
    }

    public String getDividend() {
        return this.dividendFunction.getField();
    }

    public String getDivisor() {
        return this.divisorFunction.getField();
    }

    public void setDividend(String dividend) {
        this.dividendFunction.setField(dividend);
    }

    public void setDivisor(String divisor) {
        this.divisorFunction.setField(divisor);
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public void setDependencyLevel(int level) {
        super.setDependencyLevel(level);
        this.dividendFunction.setDependencyLevel(level);
        this.divisorFunction.setDependencyLevel(level);
    }

    @Override
    public void setRuntime(ExpressionRuntime runtime) {
        super.setRuntime(runtime);
        this.dividendFunction.setRuntime(runtime);
        this.divisorFunction.setRuntime(runtime);
    }

    public String getCrosstabFilterGroup() {
        return this.dividendFunction.getCrosstabFilterGroup();
    }

    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.divisorFunction.setCrosstabFilterGroup(crosstabFilterGroup);
        this.dividendFunction.setCrosstabFilterGroup(crosstabFilterGroup);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TotalGroupSumQuotientFunction fn = (TotalGroupSumQuotientFunction)super.clone();
        fn.dividendFunction = (TotalGroupSumFunction)this.dividendFunction.clone();
        fn.divisorFunction = (TotalGroupSumFunction)this.divisorFunction.clone();
        return fn;
    }
}

