/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class ItemCountFunction
extends AbstractFunction
implements AggregationFunction {
    public static final BigDecimal ONE = new BigDecimal(1);
    public static final BigDecimal ZERO = new BigDecimal(0);
    private Sequence<BigDecimal> count;
    private transient int lastGroupSequenceNumber;
    private String group;
    private String crosstabFilterGroup;

    public ItemCountFunction() {
        this.count = new Sequence();
    }

    public ItemCountFunction(String name) {
        this.setName(name);
    }

    protected void clear() {
        this.lastGroupSequenceNumber = 0;
        this.count.clear();
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.clear();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.clear();
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        BigDecimal oldValue = this.count.get(this.lastGroupSequenceNumber);
        if (oldValue == null) {
            this.count.set(this.lastGroupSequenceNumber, ONE);
        } else {
            this.count.set(this.lastGroupSequenceNumber, oldValue.add(ONE));
        }
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public Object getValue() {
        BigDecimal value = this.count.get(this.lastGroupSequenceNumber);
        if (value == null) {
            return ZERO;
        }
        return value;
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }

    @Override
    public ItemCountFunction getInstance() {
        ItemCountFunction function = (ItemCountFunction)super.getInstance();
        function.count = this.count.clone();
        function.lastGroupSequenceNumber = 0;
        return function;
    }

    @Override
    public Object clone() {
        try {
            ItemCountFunction clone = (ItemCountFunction)super.clone();
            clone.count = this.count.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

