/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.elementfactory;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.ResourceFieldType;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;

public class ResourceFieldElementFactory
extends TextFieldElementFactory {
    private String resourceBase;

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    @Override
    public Element createElement() {
        Element element = super.createElement();
        element.setElementType(new ResourceFieldType());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-identifier", this.getResourceBase());
        return element;
    }

    public static Element createResourceElement(String name, Rectangle2D bounds, Color color, ElementAlignment alignment, ElementAlignment valignment, FontDefinition font, String nullValue, String resourceBase, String field) {
        ResourceFieldElementFactory factory = new ResourceFieldElementFactory();
        factory.setX(new Float(bounds.getX()));
        factory.setY(new Float(bounds.getY()));
        factory.setMinimumWidth(new Float(bounds.getWidth()));
        factory.setMinimumHeight(new Float(bounds.getHeight()));
        factory.setName(name);
        factory.setColor(color);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valignment);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(ElementFactory.getBooleanValue(font.isBold()));
            factory.setItalic(ElementFactory.getBooleanValue(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(ElementFactory.getBooleanValue(font.isUnderline()));
            factory.setStrikethrough(ElementFactory.getBooleanValue(font.isStrikeThrough()));
            factory.setEmbedFont(ElementFactory.getBooleanValue(font.isEmbeddedFont()));
        }
        factory.setNullString(nullValue);
        factory.setResourceBase(resourceBase);
        factory.setFieldname(field);
        return factory.createElement();
    }
}

