/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetComboBoxModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.Messages;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class NamedQueryModel<T> {
    public static final String QUERY_SELECTED = "querySelected";
    public static final String PREVIEW_POSSIBLE = "previewPossible";
    private boolean previewPossible;
    private boolean querySelected;
    private DataSetComboBoxModel<T> queries;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public NamedQueryModel() {
        this.queries = new DataSetComboBoxModel();
        this.queries.addListDataListener(new PreviewPossibleUpdateHandler());
    }

    public boolean isQuerySelected() {
        return this.querySelected;
    }

    protected void setQuerySelected(boolean querySelected) {
        this.querySelected = querySelected;
        this.propertyChangeSupport.firePropertyChange(QUERY_SELECTED, !querySelected, querySelected);
    }

    public void addQuery(String name, T value) {
        this.queries.addElement(new DataSetQuery<T>(name, value));
    }

    public void addQuery(String name, T value, String language, String script) {
        this.queries.addElement(new DataSetQuery<T>(name, value, language, script));
    }

    public boolean createQuery() {
        String queryNamePattern = Messages.getInstance().getString("NamedQueryModel.Query");
        String queryName = this.generateQueryName(queryNamePattern);
        T defaultObject = this.createDefaultObject();
        if (defaultObject == null) {
            return false;
        }
        DataSetQuery<T> query = new DataSetQuery<T>(queryName, defaultObject);
        this.queries.addElement(query);
        this.setSelectedDataSetQuery(query);
        return true;
    }

    protected abstract T createDefaultObject();

    public void setSelectedDataSetQuery(DataSetQuery<T> dataSetQuery) {
        this.queries.setSelectedItem(dataSetQuery);
    }

    public DataSetQuery<T> getSelectedDataSetQuery() {
        return this.queries.getSelectedQuery();
    }

    public void setSelectedQuery(String selectedQueryName) {
        if (selectedQueryName == null) {
            this.setSelectedDataSetQuery(null);
            return;
        }
        for (int i = 0; i < this.queries.getSize(); ++i) {
            DataSetQuery q = (DataSetQuery)this.queries.getElementAt(i);
            if (!selectedQueryName.equals(q.getQueryName())) continue;
            this.setSelectedDataSetQuery(q);
            return;
        }
    }

    public String generateQueryName(String queryName) {
        DataSetComboBoxModel<T> queries = this.getQueries();
        for (int i = 1; i < 1000; ++i) {
            String newQuery = queryName + " " + i;
            if (queries.getIndexForQuery(newQuery) != -1) continue;
            return newQuery;
        }
        return queryName;
    }

    protected void validateState() {
        DataSetComboBoxModel<T> queries = this.getQueries();
        this.setQuerySelected(queries.getSelectedItem() != null);
        if (queries.getSelectedItem() == null) {
            this.setPreviewPossible(false);
            return;
        }
        DataSetQuery o = (DataSetQuery)queries.getSelectedItem();
        if (o == null || StringUtils.isEmpty((String)o.getQueryName())) {
            this.setPreviewPossible(false);
            return;
        }
        this.setPreviewPossible(true);
    }

    public void clear() {
        this.queries.removeAllElements();
        this.setPreviewPossible(false);
    }

    public boolean isPreviewPossible() {
        return this.previewPossible;
    }

    public void setPreviewPossible(boolean previewPossible) {
        boolean oldPreviewPossible = this.previewPossible;
        this.previewPossible = previewPossible;
        this.propertyChangeSupport.firePropertyChange(PREVIEW_POSSIBLE, oldPreviewPossible, previewPossible);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public DataSetComboBoxModel<T> getQueries() {
        return this.queries;
    }

    private class PreviewPossibleUpdateHandler
    implements ListDataListener {
        private PreviewPossibleUpdateHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            NamedQueryModel.this.validateState();
        }
    }
}

