/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabOtherGroupType;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;

public class CrosstabOtherGroup
extends Group {
    private GroupHeader header;
    private GroupFooter footer;

    public CrosstabOtherGroup() {
        this.init();
    }

    public CrosstabOtherGroup(GroupBody body) {
        super(body);
        this.validateBody(body);
        this.init();
    }

    public CrosstabOtherGroup(CrosstabCellBody body) {
        super(body);
        this.init();
    }

    public CrosstabOtherGroup(CrosstabColumnGroupBody body) {
        super(body);
        this.init();
    }

    private void init() {
        this.setElementType(new CrosstabOtherGroupType());
        this.footer = new GroupFooter();
        this.header = new GroupHeader();
        this.registerAsChild(this.footer);
        this.registerAsChild(this.header);
    }

    public GroupHeader getHeader() {
        return this.header;
    }

    public void setHeader(GroupHeader header) {
        if (header == null) {
            throw new NullPointerException("Header must not be null");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        GroupHeader element = this.header;
        this.header.setParent(null);
        this.header = header;
        this.header.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.header);
    }

    public GroupFooter getFooter() {
        return this.footer;
    }

    public void setFooter(GroupFooter footer) {
        if (footer == null) {
            throw new NullPointerException("The footer must not be null");
        }
        this.validateLooping(footer);
        if (this.unregisterParent(footer)) {
            return;
        }
        GroupFooter element = this.footer;
        this.footer.setParent(null);
        this.footer = footer;
        this.footer.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.footer);
    }

    @Override
    public CrosstabOtherGroup clone() {
        CrosstabOtherGroup g = (CrosstabOtherGroup)super.clone();
        g.footer = (GroupFooter)this.footer.clone();
        g.header = (GroupHeader)this.header.clone();
        g.registerAsChild(g.footer);
        g.registerAsChild(g.header);
        return g;
    }

    @Override
    public CrosstabOtherGroup derive(boolean preserveElementInstanceIds) {
        CrosstabOtherGroup g = (CrosstabOtherGroup)super.derive(preserveElementInstanceIds);
        g.footer = (GroupFooter)this.footer.derive(preserveElementInstanceIds);
        g.header = (GroupHeader)this.header.derive(preserveElementInstanceIds);
        g.registerAsChild(g.footer);
        g.registerAsChild(g.header);
        return g;
    }

    @Override
    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.footer == element) {
            this.footer.setParent(null);
            this.footer = new GroupFooter();
            this.footer.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.footer);
        } else if (this.header == element) {
            this.header.setParent(null);
            this.header = new GroupHeader();
            this.header.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.header);
        } else {
            super.removeElement(element);
        }
    }

    @Override
    public Element getElement(int index) {
        switch (index) {
            case 0: {
                return this.header;
            }
            case 1: {
                return this.getBody();
            }
            case 2: {
                return this.footer;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getElementCount() {
        return 3;
    }

    @Override
    public void setElementAt(int index, Element element) {
        switch (index) {
            case 0: {
                this.setHeader((GroupHeader)element);
                break;
            }
            case 1: {
                this.setBody((GroupBody)element);
                break;
            }
            case 2: {
                this.setFooter((GroupFooter)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public String getField() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void setField(String field) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", field);
        this.notifyNodePropertiesChanged();
    }

    @Override
    protected GroupBody createDefaultBody() {
        return new CrosstabRowGroupBody();
    }

    @Override
    public void setBody(GroupBody body) {
        this.validateBody(body);
        super.setBody(body);
    }

    private void validateBody(GroupBody body) {
        if (!(body instanceof CrosstabRowGroupBody) && !(body instanceof CrosstabOtherGroupBody)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isGroupChange(DataRow dataRow) {
        String fieldName = this.getField();
        if (fieldName == null) {
            return false;
        }
        return dataRow.isChanged(fieldName);
    }

    @Override
    public List<SortConstraint> getSortingConstraint() {
        return this.mapFields(Collections.singletonList(this.getField()));
    }
}

