/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class WindowsFileParser
extends FTPFileParser {
    public static String cvsId = "@(#)$Id: WindowsFileParser.java,v 1.15 2008-07-15 05:41:33 bruceb Exp $";
    private static Logger log = Logger.getLogger("WindowsFileParser");
    private SimpleDateFormat formatter;
    private static final String DIR = "<DIR>";
    private static final int MIN_EXPECTED_FIELD_COUNT = 4;

    public WindowsFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public String toString() {
        return "Windows";
    }

    public void setLocale(Locale locale) {
        this.formatter = new SimpleDateFormat("MM-dd-yy hh:mma", locale);
    }

    public boolean isValidFormat(String[] listing) {
        int count = Math.min(listing.length, 10);
        boolean dateStart = false;
        boolean timeColon = false;
        boolean dirOrFile = false;
        for (int i = 0; i < count; ++i) {
            String[] fields;
            if (listing[i].trim().length() == 0 || (fields = this.split(listing[i])).length < 4) continue;
            if (Character.isDigit(fields[0].charAt(0)) && Character.isDigit(fields[0].charAt(fields[0].length() - 1))) {
                dateStart = true;
            }
            if (fields[1].indexOf(58) > 0) {
                timeColon = true;
            }
            if (!fields[2].equalsIgnoreCase(DIR) && !Character.isDigit(fields[2].charAt(0))) continue;
            dirOrFile = true;
        }
        if (dateStart && timeColon && dirOrFile) {
            return true;
        }
        log.debug("Not in Windows format");
        return false;
    }

    public FTPFile parse(String raw) throws ParseException {
        Date lastModified;
        String[] fields;
        block11: {
            fields = this.split(raw);
            if (fields.length < 4) {
                return null;
            }
            lastModified = null;
            try {
                lastModified = this.formatter.parse(fields[0] + " " + fields[1]);
            }
            catch (ParseException ex) {
                if (this.ignoreDateParseErrors) break block11;
                throw new DateParseException(ex.getMessage());
            }
        }
        boolean isDir = false;
        long size = 0L;
        if (fields[2].equalsIgnoreCase(DIR)) {
            isDir = true;
        } else {
            try {
                size = Long.parseLong(fields[2]);
            }
            catch (NumberFormatException ex) {
                log.warn("Failed to parse size: " + fields[2]);
            }
        }
        int pos = 0;
        boolean ok = true;
        for (int i = 0; i < 3; ++i) {
            if ((pos = raw.indexOf(fields[i], pos)) < 0) {
                ok = false;
                break;
            }
            pos += fields[i].length();
        }
        String name = null;
        if (ok) {
            name = this.trimStart(raw.substring(pos));
        } else {
            log.warn("Failed to retrieve name: " + raw);
        }
        return new FTPFile(raw, name, size, isDir, lastModified);
    }
}

