/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationExecutor;
import org.pentaho.di.engine.configuration.api.RunConfigurationProvider;
import org.pentaho.di.engine.configuration.api.RunConfigurationService;
import org.pentaho.di.engine.configuration.impl.pentaho.DefaultRunConfigurationProvider;

public class RunConfigurationManager
implements RunConfigurationService {
    private RunConfigurationProvider defaultRunConfigurationProvider;
    private List<RunConfigurationProvider> runConfigurationProviders = new ArrayList<RunConfigurationProvider>();
    private static RunConfigurationManager instance;

    public static RunConfigurationManager getInstance() {
        if (null == instance) {
            instance = new RunConfigurationManager();
        }
        return instance;
    }

    public RunConfigurationManager(List<RunConfigurationProvider> runConfigurationProviders) {
        this.runConfigurationProviders = runConfigurationProviders;
    }

    private RunConfigurationManager() {
        this.defaultRunConfigurationProvider = new DefaultRunConfigurationProvider();
    }

    @Override
    public List<RunConfiguration> load() {
        ArrayList<RunConfiguration> runConfigurations = new ArrayList<RunConfiguration>();
        for (RunConfigurationProvider runConfigurationProvider : this.getRunConfigurationProviders()) {
            runConfigurations.addAll(runConfigurationProvider.load());
        }
        Collections.sort(runConfigurations, (o1, o2) -> {
            if (o2.getName().equals("Pentaho local")) {
                return 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        });
        return runConfigurations;
    }

    @Override
    public RunConfiguration load(String name) {
        for (RunConfigurationProvider runConfigurationProvider : this.getRunConfigurationProviders()) {
            RunConfiguration runConfiguration = runConfigurationProvider.load(name);
            if (runConfiguration == null) continue;
            return runConfiguration;
        }
        return null;
    }

    @Override
    public boolean save(RunConfiguration runConfiguration) {
        RunConfigurationProvider runConfigurationProvider = runConfiguration != null ? this.getProvider(runConfiguration.getType()) : null;
        return runConfigurationProvider != null && runConfigurationProvider.save(runConfiguration);
    }

    @Override
    public boolean delete(String name) {
        for (RunConfigurationProvider runConfigurationProvider : this.getRunConfigurationProviders()) {
            if (runConfigurationProvider.load(name) == null || !runConfigurationProvider.delete(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteAll() {
        for (RunConfigurationProvider runConfigurationProvider : this.getRunConfigurationProviders()) {
            runConfigurationProvider.deleteAll();
        }
    }

    @Override
    public String[] getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (RunConfigurationProvider runConfigurationProvider : this.getRunConfigurationProviders()) {
            types.add(runConfigurationProvider.getType());
        }
        return types.toArray(new String[0]);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (RunConfigurationProvider runConfigurationProvider : this.getRunConfigurationProviders()) {
            names.addAll(runConfigurationProvider.getNames());
        }
        Collections.sort(names, (o1, o2) -> {
            if (o2.equals("Pentaho local")) {
                return 1;
            }
            return o1.compareToIgnoreCase((String)o2);
        });
        return names;
    }

    @Override
    public List<String> getNames(String type) {
        ArrayList<String> names = new ArrayList<String>();
        for (RunConfigurationProvider runConfigurationProvider : this.getRunConfigurationProviders(type)) {
            names.addAll(runConfigurationProvider.getNames());
        }
        Collections.sort(names, (o1, o2) -> {
            if (o2.equals("Pentaho local")) {
                return 1;
            }
            return o1.compareToIgnoreCase((String)o2);
        });
        return names;
    }

    @Override
    public RunConfiguration getRunConfigurationByType(String type) {
        RunConfigurationProvider runConfigurationProvider = this.getProvider(type);
        if (runConfigurationProvider != null) {
            return runConfigurationProvider.getConfiguration();
        }
        return null;
    }

    @Override
    public RunConfigurationExecutor getExecutor(String type) {
        RunConfigurationProvider runConfigurationProvider = this.getProvider(type);
        if (runConfigurationProvider != null) {
            return runConfigurationProvider.getExecutor();
        }
        return null;
    }

    private RunConfigurationProvider getProvider(String type) {
        for (RunConfigurationProvider runConfigurationProvider : this.getRunConfigurationProviders()) {
            if (!runConfigurationProvider.getType().equals(type)) continue;
            return runConfigurationProvider;
        }
        return null;
    }

    public List<RunConfigurationProvider> getRunConfigurationProviders(String type) {
        ArrayList<RunConfigurationProvider> runConfigurationProviders = new ArrayList<RunConfigurationProvider>();
        if (this.defaultRunConfigurationProvider != null) {
            runConfigurationProviders.add(this.defaultRunConfigurationProvider);
        }
        for (RunConfigurationProvider runConfigurationProvider : this.runConfigurationProviders) {
            if (!runConfigurationProvider.isSupported(type)) continue;
            runConfigurationProviders.add(runConfigurationProvider);
        }
        return runConfigurationProviders;
    }

    public List<RunConfigurationProvider> getRunConfigurationProviders() {
        ArrayList<RunConfigurationProvider> runConfigurationProviders = new ArrayList<RunConfigurationProvider>();
        if (this.defaultRunConfigurationProvider != null) {
            runConfigurationProviders.add(this.defaultRunConfigurationProvider);
        }
        runConfigurationProviders.addAll(this.runConfigurationProviders);
        return runConfigurationProviders;
    }

    public RunConfigurationProvider getDefaultRunConfigurationProvider() {
        return this.defaultRunConfigurationProvider;
    }

    public void setDefaultRunConfigurationProvider(RunConfigurationProvider defaultRunConfigurationProvider) {
        this.defaultRunConfigurationProvider = defaultRunConfigurationProvider;
    }
}

