/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.criptdecriptjson;

import com.totvscrm.pentaho.step.criptdecriptjson.CriptDecriptJsonStepData;
import com.totvscrm.pentaho.step.criptdecriptjson.CriptDecriptJsonStepMeta;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class CriptDecriptJsonStep
extends BaseStep
implements StepInterface {
    CriptDecriptJsonStepMeta meta;
    CriptDecriptJsonStepData data;

    public CriptDecriptJsonStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CriptDecriptJsonStepMeta)smi;
        this.data = (CriptDecriptJsonStepData)sdi;
        if (super.init((StepMetaInterface)this.meta, (StepDataInterface)this.data)) {
            this.logBasic("Inicializando o plug-in");
            return true;
        }
        return false;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CriptDecriptJsonStepMeta)smi;
        this.data = (CriptDecriptJsonStepData)sdi;
        String stringCriptDecript = "";
        this.logBasic("Processando linha!");
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.logRowlevel("Processando a primeira linha");
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, null, null);
        }
        for (int i = 0; i < this.getInputRowMeta().size(); ++i) {
            String valuemeta = this.getInputRowMeta().getFieldNames()[i];
            if (!valuemeta.equals(this.meta.getInputField())) continue;
            String dataCriptDecript = this.getInputRowMeta().getValueMeta(i).getString(r[i]);
            if (this.meta.getCriptDecript() == 0) {
                stringCriptDecript = this.compressStringToBase64(dataCriptDecript);
                break;
            }
            if (this.meta.getCriptDecript() == 1) {
                stringCriptDecript = this.decompressStringFromBase64(dataCriptDecript);
                break;
            }
            this.logBasic("A op\u00e7\u00e3o selecionada para o campo \"Criptografar / Descriptografar\" n\u00e3o \u00e9 v\u00e1lida");
            break;
        }
        Object[] outputRow = RowDataUtil.addValueData((Object[])r, (int)(this.data.outputRowMeta.size() - 1), (Object)stringCriptDecript);
        this.putRow(this.data.outputRowMeta, outputRow);
        return true;
    }

    private String compressStringToBase64(String data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());
            GZIPOutputStream gzip = new GZIPOutputStream(bos);
            gzip.write(data.getBytes("UTF8"));
            gzip.close();
            byte[] compressed = bos.toByteArray();
            bos.close();
            compressed = Base64.getEncoder().encode(compressed);
            this.logBasic("Campo criptografado com sucesso");
            return new String(compressed);
        }
        catch (IOException e) {
            this.logBasic("Houve um erro ao criptografar o texto: \n" + e.getMessage());
            return null;
        }
    }

    private String decompressStringFromBase64(String compressedText) {
        try {
            int bytesRead;
            byte[] compressed = compressedText.getBytes();
            Base64.Decoder d = Base64.getDecoder();
            try {
                compressed = d.decode(compressed);
            }
            catch (Exception e) {
                this.logBasic("N\u00e3o foi poss\u00edvel descriptografar, a String informada n\u00e3o parece estar no formato Base64");
            }
            int BUFFER_SIZE = 32;
            ByteArrayInputStream is = new ByteArrayInputStream(compressed);
            GZIPInputStream gis = new GZIPInputStream((InputStream)is, 32);
            StringBuilder string = new StringBuilder();
            byte[] data = new byte[32];
            while ((bytesRead = gis.read(data)) != -1) {
                string.append(new String(data, 0, bytesRead));
            }
            gis.close();
            is.close();
            if (this.isDetailed() || this.isDebug() || this.isRowLevel()) {
                this.logBasic(string.toString());
            }
            this.logBasic("Campo descriptografado com sucesso");
            return string.toString();
        }
        catch (IOException e) {
            this.logBasic("Houve um erro ao descriptografar o texto: \n" + e.getMessage());
            return "Houve um erro ao tentar descriptografar o texto";
        }
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.logBasic("Encerrando o plug-in");
        CriptDecriptJsonStepMeta meta = (CriptDecriptJsonStepMeta)smi;
        CriptDecriptJsonStepData data = (CriptDecriptJsonStepData)sdi;
        super.dispose((StepMetaInterface)meta, (StepDataInterface)data);
    }
}

