/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class IconManager {
    private static final Object NO_ICON;
    private static final HashMap map;
    private static final HashMap localizedMap;
    private static final Set extraInitialSlashes;
    private static ClassLoader currentLoader;
    private static Lookup.Result loaderQuery;
    private static boolean noLoaderWarned;
    private static final Component component;
    private static final MediaTracker tracker;
    private static int mediaTrackerID;
    static final /* synthetic */ boolean $assertionsDisabled;

    IconManager() {
    }

    private static ClassLoader getLoader() {
        if (currentLoader == null) {
            Iterator iterator;
            if (loaderQuery == null) {
                loaderQuery = Lookup.getDefault().lookup(new Lookup.Template(ClassLoader.class));
                loaderQuery.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        currentLoader = null;
                    }
                });
            }
            if ((iterator = loaderQuery.allInstances().iterator()).hasNext()) {
                currentLoader = (ClassLoader)iterator.next();
            } else if (!noLoaderWarned) {
                noLoaderWarned = true;
                ErrorManager.getDefault().log(16, "No ClassLoader instance found in " + Lookup.getDefault());
            }
        }
        return currentLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getIcon(String string, boolean bl) {
        if (bl) {
            HashMap hashMap = localizedMap;
            synchronized (hashMap) {
                String string2;
                String string3;
                Object object = localizedMap.get(string);
                if (object == NO_ICON) {
                    return null;
                }
                if (object != null) {
                    object = ((Reference)object).get();
                }
                if (object != null) {
                    return (Image)object;
                }
                ClassLoader classLoader = IconManager.getLoader();
                int n = (string = new String(string).intern()).lastIndexOf(46);
                if (n != -1 && n > string.lastIndexOf(47)) {
                    string3 = string.substring(0, n);
                    string2 = string.substring(n);
                } else {
                    string3 = string;
                    string2 = "";
                }
                Image image = IconManager.getIcon(string, classLoader, false);
                Iterator iterator = NbBundle.getLocalizingSuffixes();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    Image image2 = string4.length() == 0 ? image : IconManager.getIcon(string3 + string4 + string2, classLoader, true);
                    if (image2 == null) continue;
                    localizedMap.put(string, new ActiveRef(image2, localizedMap, string));
                    return image2;
                }
                localizedMap.put(string, NO_ICON);
                return null;
            }
        }
        return IconManager.getIcon(string);
    }

    private static Image getIcon(String string) {
        Object object = map.get(string);
        if (object == NO_ICON) {
            return null;
        }
        if (object != null) {
            object = ((Reference)object).get();
        }
        if (object != null) {
            return (Image)object;
        }
        ClassLoader classLoader = IconManager.getLoader();
        string = new String(string).intern();
        return IconManager.getIcon(string, classLoader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getIcon(String string, ClassLoader classLoader, boolean bl) {
        Object object = map.get(string);
        if (object == NO_ICON) {
            return null;
        }
        if (object != null) {
            object = ((Reference)object).get();
        }
        if (object != null) {
            return (Image)object;
        }
        HashMap hashMap = map;
        synchronized (hashMap) {
            String string2;
            boolean bl2;
            object = map.get(string);
            if (object == NO_ICON) {
                return null;
            }
            if (object != null) {
                object = ((Reference)object).get();
            }
            if (object != null) {
                return (Image)object;
            }
            if (string.startsWith("/")) {
                bl2 = true;
                string2 = string.substring(1);
            } else {
                bl2 = false;
                string2 = string;
            }
            URL uRL = classLoader != null ? classLoader.getResource(string2) : IconManager.class.getClassLoader().getResource(string2);
            Image image = object = uRL == null ? null : Toolkit.getDefaultToolkit().createImage(uRL);
            if (object != null) {
                if (bl2 && extraInitialSlashes.add(string)) {
                    ErrorManager.getDefault().log(16, "Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + string);
                }
                Image image2 = IconManager.toBufferedImage((Image)object);
                if (bl) {
                    string = new String(string).intern();
                }
                map.put(string, new ActiveRef(image2, map, string));
                return image2;
            }
            if (!bl) {
                map.put(string, NO_ICON);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Image mergeImages(Image image, Image image2, int n, int n2) {
        CompositeImageKey compositeImageKey = new CompositeImageKey(image, image2, n, n2);
        HashMap hashMap = map;
        synchronized (hashMap) {
            Image image3;
            Reference reference = (Reference)map.get(compositeImageKey);
            if (reference != null && (image3 = (Image)reference.get()) != null) {
                return image3;
            }
            image3 = IconManager.doMergeImages(image, image2, n, n2);
            map.put(compositeImageKey, new ActiveRef(image3, map, compositeImageKey));
            return image3;
        }
    }

    static final Image toBufferedImage(Image image) {
        new ImageIcon(image);
        BufferedImage bufferedImage = IconManager.createBufferedImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        image.flush();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int n = ++mediaTrackerID;
            tracker.addImage(image, n);
            try {
                tracker.waitForID(n, 0L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            if (!$assertionsDisabled && tracker.statusID(n, false) != 8) {
                throw new AssertionError((Object)"Image loaded");
            }
            tracker.removeImage(image, n);
        }
    }

    private static final Image doMergeImages(Image image, Image image2, int n, int n2) {
        IconManager.ensureLoaded(image);
        IconManager.ensureLoaded(image2);
        int n3 = Math.max(image.getWidth(null), n + image2.getWidth(null));
        int n4 = Math.max(image.getHeight(null), n2 + image2.getHeight(null));
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n4), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.drawImage(image2, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    static final BufferedImage createBufferedImage(int n, int n2) {
        if (Utilities.getOperatingSystem() == 4096) {
            return new BufferedImage(n, n2, 3);
        }
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(3);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    static {
        $assertionsDisabled = !IconManager.class.desiredAssertionStatus();
        NO_ICON = new Object();
        map = new HashMap(128);
        localizedMap = new HashMap(128);
        extraInitialSlashes = new HashSet();
        currentLoader = null;
        loaderQuery = null;
        noLoaderWarned = false;
        component = new Component(){};
        tracker = new MediaTracker(component);
    }

    private static final class ActiveRef
    extends SoftReference
    implements Runnable {
        private Map holder;
        private Object key;

        public ActiveRef(Object object, Map map, Object object2) {
            super(object, Utilities.activeReferenceQueue());
            this.holder = map;
            this.key = object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = this.holder;
            synchronized (map) {
                this.holder.remove(this.key);
            }
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image image, Image image2, int n, int n2) {
            this.x = n;
            this.y = n2;
            this.baseImage = image;
            this.overlayImage = image2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey compositeImageKey = (CompositeImageKey)object;
            return this.x == compositeImageKey.x && this.y == compositeImageKey.y && this.baseImage == compositeImageKey.baseImage && this.overlayImage == compositeImageKey.overlayImage;
        }

        public int hashCode() {
            int n = (this.x << 3 ^ this.y) << 4;
            n = n ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return n;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

