/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;

public class MetaInjectMigration {
    private static Map<String, String> migrationMappings = new HashMap<String, String>();

    public static void migrate(Map<TargetStepAttribute, SourceStepField> targetSourceMapping) {
        for (TargetStepAttribute oldTarget : new ArrayList<TargetStepAttribute>(targetSourceMapping.keySet())) {
            for (Map.Entry<String, String> mapping : migrationMappings.entrySet()) {
                if (!mapping.getKey().equals(oldTarget.getAttributeKey())) continue;
                SourceStepField so = targetSourceMapping.remove(oldTarget);
                TargetStepAttribute newTarget = new TargetStepAttribute(oldTarget.getStepname(), mapping.getValue(), oldTarget.isDetail());
                targetSourceMapping.put(newTarget, so);
            }
        }
    }

    static {
        migrationMappings.put("SCHENAMENAMEFIELD", "SCHEMANAMEFIELD");
        migrationMappings.put("DATABASE_FIELDNAME", "DATABASE_FIELD_NAME");
        migrationMappings.put("STREAM_FIELDNAME", "DATABASE_STREAM_NAME");
    }
}

