/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.metainject.MetaInject;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.di.trans.steps.metainject.MetaInjectOutputField;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.events.dialog.FilterType;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.DialogHelper;
import org.pentaho.di.ui.util.DialogUtils;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

@PluginDialog(id="MetaInject", image="org/pentaho/di/trans/steps/metainject/img/GenericTransform.svg", pluginType=PluginDialog.PluginType.STEP)
public class MetaInjectDialog
extends BaseStepDialog
implements StepDialogInterface {
    public static final String CONST_VALUE = "<const>";
    private static Class<?> PKG = MetaInjectMeta.class;
    private MetaInjectMeta metaInjectMeta;
    private Label wlPath;
    private TextVar wPath;
    private Button wbBrowse;
    private CTabFolder wTabFolder;
    private CTabItem wOptionsTab;
    private ScrolledComposite wOptionsSComp;
    private Composite wOptionsComp;
    private CTabItem wInjectTab;
    private ScrolledComposite wInjectSComp;
    private Composite wInjectComp;
    private TransMeta injectTransMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private CCombo wSourceStep;
    private TableView wSourceFields;
    private TextVar wTargetFile;
    private Button wNoExecution;
    private Label wlStreamingSourceStep;
    private CCombo wStreamingSourceStep;
    private Label wlStreamingTargetStep;
    private CCombo wStreamingTargetStep;
    private Tree wTree;
    private Map<TreeItem, TargetStepAttribute> treeItemTargetMap;
    private Map<TargetStepAttribute, SourceStepField> targetSourceMapping;

    public MetaInjectDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.metaInjectMeta = (MetaInjectMeta)((Object)in);
        this.transModified = false;
        this.targetSourceMapping = new HashMap<TargetStepAttribute, SourceStepField>();
        this.targetSourceMapping.putAll(this.metaInjectMeta.getTargetSourceMapping());
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.metaInjectMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MetaInjectDialog.this.metaInjectMeta.setChanged();
            }
        };
        this.changed = this.metaInjectMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Transformation.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlTransformation);
        this.wPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment(0, 0);
        fdTransformation.top = new FormAttachment((Control)this.wlPath, 5);
        fdTransformation.width = 350;
        this.wPath.setLayoutData((Object)fdTransformation);
        this.wPath.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MetaInjectDialog.this.refreshTree();
            }
        });
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.left = new FormAttachment((Control)this.wPath, 5);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, Const.isOSX() ? 0 : 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wbBrowse.addSelectionListener((SelectionListener)DialogHelper.constructSelectionAdapterFileDialogTextVarForKettleFile((LogChannel)this.log, (TextVar)this.wPath, (AbstractMeta)this.transMeta, (SelectionOperation)SelectionOperation.FILE_OR_FOLDER, (FilterType)FilterType.KETTLE_TRANS, (Repository)this.repository));
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wPath, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addInjectTab();
        this.addOptionsTab();
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MetaInjectDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MetaInjectDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MetaInjectDialog.this.ok();
            }
        };
        this.wPath.addSelectionListener(this.lsDef);
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MetaInjectDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.metaInjectMeta.setChanged(this.changed);
        this.shell.open();
        this.checkInvalidMapping();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"GenericTransform.svg", (int)48, (int)48);
    }

    private void checkInvalidMapping() {
        if (this.injectTransMeta == null) {
            try {
                if (!this.loadTransformation()) {
                    return;
                }
            }
            catch (KettleException e) {
                this.showErrorOnLoadTransformationDialog(e);
                return;
            }
        }
        Set<SourceStepField> unavailableSourceSteps = MetaInject.getUnavailableSourceSteps(this.targetSourceMapping, this.transMeta, this.stepMeta);
        Set<TargetStepAttribute> unavailableTargetSteps = MetaInject.getUnavailableTargetSteps(this.targetSourceMapping, this.injectTransMeta);
        Set<TargetStepAttribute> missingTargetKeys = MetaInject.getUnavailableTargetKeys(this.targetSourceMapping, this.injectTransMeta, unavailableTargetSteps);
        if (unavailableSourceSteps.isEmpty() && unavailableTargetSteps.isEmpty() && missingTargetKeys.isEmpty()) {
            return;
        }
        this.showInvalidMappingDialog(unavailableSourceSteps, unavailableTargetSteps, missingTargetKeys);
    }

    private void showInvalidMappingDialog(Set<SourceStepField> unavailableSourceSteps, Set<TargetStepAttribute> unavailableTargetSteps, Set<TargetStepAttribute> missingTargetKeys) {
        MessageBox mb = new MessageBox(this.shell, 196);
        mb.setMessage(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InvalidMapping.Question", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InvalidMapping.Title", (String[])new String[0]));
        int id = mb.open();
        if (id == 64) {
            MetaInject.removeUnavailableStepsFromMapping(this.targetSourceMapping, unavailableSourceSteps, unavailableTargetSteps);
            for (TargetStepAttribute target : missingTargetKeys) {
                this.targetSourceMapping.remove(target);
            }
        }
    }

    private void showErrorOnLoadTransformationDialog(KettleException e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
    }

    private void addOptionsTab() {
        this.wOptionsTab = new CTabItem(this.wTabFolder, 0);
        this.wOptionsTab.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.OptionsTab.TabTitle", (String[])new String[0]));
        this.wOptionsSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        this.wOptionsSComp.setLayout((Layout)new FillLayout());
        this.wOptionsComp = new Composite((Composite)this.wOptionsSComp, 0);
        this.props.setLook((Control)this.wOptionsComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 15;
        fileLayout.marginHeight = 15;
        this.wOptionsComp.setLayout((Layout)fileLayout);
        Label wlSourceStep = new Label(this.wOptionsComp, 131072);
        wlSourceStep.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.SourceStep.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSourceStep);
        FormData fdlSourceStep = new FormData();
        fdlSourceStep.left = new FormAttachment(0, 0);
        fdlSourceStep.top = new FormAttachment(0, 0);
        wlSourceStep.setLayoutData((Object)fdlSourceStep);
        this.wSourceStep = new CCombo(this.wOptionsComp, 18436);
        this.props.setLook((Control)this.wSourceStep);
        this.wSourceStep.addModifyListener(this.lsMod);
        FormData fdSourceStep = new FormData();
        fdSourceStep.width = 300;
        fdSourceStep.left = new FormAttachment(0, 0);
        fdSourceStep.top = new FormAttachment((Control)wlSourceStep, 5);
        this.wSourceStep.setLayoutData((Object)fdSourceStep);
        this.wSourceStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MetaInjectDialog.this.setActive();
            }
        });
        int fieldRows = this.metaInjectMeta.getSourceOutputFields().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Fieldname", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getAllValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wSourceFields = new TableView((VariableSpace)this.transMeta, this.wOptionsComp, 67586, colinf, fieldRows, false, this.lsMod, this.props, false);
        FormData fdFields = new FormData();
        fdFields.height = 150;
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wSourceStep, 10);
        fdFields.right = new FormAttachment(100, 0);
        this.wSourceFields.setLayoutData((Object)fdFields);
        this.wSourceFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 25, 25, 25, 25}));
        Label wlTargetFile = new Label(this.wOptionsComp, 131072);
        wlTargetFile.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.TargetFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTargetFile);
        FormData fdlTargetFile = new FormData();
        fdlTargetFile.left = new FormAttachment(0, 0);
        fdlTargetFile.top = new FormAttachment((Control)this.wSourceFields, 10);
        wlTargetFile.setLayoutData((Object)fdlTargetFile);
        this.wTargetFile = new TextVar((VariableSpace)this.transMeta, this.wOptionsComp, 18436);
        this.props.setLook((Control)this.wTargetFile);
        this.wTargetFile.addModifyListener(this.lsMod);
        FormData fdTargetFile = new FormData();
        fdTargetFile.width = 300;
        fdTargetFile.left = new FormAttachment(0, 0);
        fdTargetFile.top = new FormAttachment((Control)wlTargetFile, 5);
        this.wTargetFile.setLayoutData((Object)fdTargetFile);
        this.wlStreamingSourceStep = new Label(this.wOptionsComp, 131072);
        this.wlStreamingSourceStep.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.StreamingSourceStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStreamingSourceStep);
        FormData fdlStreamingSourceStep = new FormData();
        fdlStreamingSourceStep.left = new FormAttachment(0, 0);
        fdlStreamingSourceStep.top = new FormAttachment((Control)this.wTargetFile, 10);
        this.wlStreamingSourceStep.setLayoutData((Object)fdlStreamingSourceStep);
        this.wStreamingSourceStep = new CCombo(this.wOptionsComp, 18436);
        this.props.setLook((Control)this.wStreamingSourceStep);
        FormData fdStreamingSourceStep = new FormData();
        fdStreamingSourceStep.width = 300;
        fdStreamingSourceStep.left = new FormAttachment(0, 0);
        fdStreamingSourceStep.top = new FormAttachment((Control)this.wlStreamingSourceStep, 5);
        this.wStreamingSourceStep.setLayoutData((Object)fdStreamingSourceStep);
        this.wStreamingSourceStep.setItems(this.transMeta.getStepNames());
        this.wStreamingSourceStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MetaInjectDialog.this.setActive();
            }
        });
        this.wlStreamingTargetStep = new Label(this.wOptionsComp, 131072);
        this.wlStreamingTargetStep.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.StreamingTargetStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStreamingTargetStep);
        FormData fdlStreamingTargetStep = new FormData();
        fdlStreamingTargetStep.left = new FormAttachment(0, 0);
        fdlStreamingTargetStep.top = new FormAttachment((Control)this.wStreamingSourceStep, 10);
        this.wlStreamingTargetStep.setLayoutData((Object)fdlStreamingTargetStep);
        this.wStreamingTargetStep = new CCombo(this.wOptionsComp, 18436);
        this.props.setLook((Control)this.wStreamingTargetStep);
        FormData fdStreamingTargetStep = new FormData();
        fdStreamingTargetStep.width = 300;
        fdStreamingTargetStep.left = new FormAttachment(0, 0);
        fdStreamingTargetStep.top = new FormAttachment((Control)this.wlStreamingTargetStep, 5);
        this.wStreamingTargetStep.setLayoutData((Object)fdStreamingTargetStep);
        this.wNoExecution = new Button(this.wOptionsComp, 32);
        this.wNoExecution.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.NoExecution.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wNoExecution);
        FormData fdNoExecution = new FormData();
        fdNoExecution.width = 350;
        fdNoExecution.left = new FormAttachment(0, 0);
        fdNoExecution.top = new FormAttachment((Control)this.wStreamingTargetStep, 10);
        this.wNoExecution.setLayoutData((Object)fdNoExecution);
        FormData fdOptionsComp = new FormData();
        fdOptionsComp.left = new FormAttachment(0, 0);
        fdOptionsComp.top = new FormAttachment(0, 0);
        fdOptionsComp.right = new FormAttachment(100, 0);
        fdOptionsComp.bottom = new FormAttachment(100, 0);
        this.wOptionsComp.setLayoutData((Object)fdOptionsComp);
        this.wOptionsComp.pack();
        Rectangle bounds = this.wOptionsComp.getBounds();
        this.wOptionsSComp.setContent((Control)this.wOptionsComp);
        this.wOptionsSComp.setExpandHorizontal(true);
        this.wOptionsSComp.setExpandVertical(true);
        this.wOptionsSComp.setMinWidth(bounds.width);
        this.wOptionsSComp.setMinHeight(bounds.height);
        this.wOptionsTab.setControl((Control)this.wOptionsSComp);
    }

    private void addInjectTab() {
        this.wInjectTab = new CTabItem(this.wTabFolder, 0);
        this.wInjectTab.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InjectTab.TabTitle", (String[])new String[0]));
        this.wInjectSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        this.wInjectSComp.setLayout((Layout)new FillLayout());
        this.wInjectComp = new Composite((Composite)this.wInjectSComp, 0);
        this.props.setLook((Control)this.wInjectComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 15;
        fileLayout.marginHeight = 15;
        this.wInjectComp.setLayout((Layout)fileLayout);
        this.wTree = new Tree(this.wInjectComp, 68356);
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)fdTree);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.TargetStep", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.TargetDescription", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.SourceStep", (String[])new String[0]), 2, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.SourceField", (String[])new String[0]), 2, false, true)};
        this.wTree.setHeaderVisible(true);
        for (int i = 0; i < colinf.length; ++i) {
            ColumnInfo columnInfo = colinf[i];
            TreeColumn treeColumn = new TreeColumn(this.wTree, columnInfo.getAllignement());
            treeColumn.setText(columnInfo.getName());
            treeColumn.setWidth(200);
        }
        this.wTree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                try {
                    TargetStepAttribute target;
                    Point point = new Point(event.x, event.y);
                    TreeItem item = MetaInjectDialog.this.wTree.getItem(point);
                    if (item != null && (target = (TargetStepAttribute)MetaInjectDialog.this.treeItemTargetMap.get(item)) != null) {
                        String selectedStepField;
                        SourceStepField source = (SourceStepField)MetaInjectDialog.this.targetSourceMapping.get(target);
                        Object[] prevStepNames = MetaInjectDialog.this.transMeta.getPrevStepNames(MetaInjectDialog.this.stepMeta);
                        Arrays.sort(prevStepNames);
                        HashMap<String, SourceStepField> fieldMap = new HashMap<String, SourceStepField>();
                        for (Object prevStepName : prevStepNames) {
                            RowMetaInterface fields = MetaInjectDialog.this.transMeta.getStepFields((String)prevStepName);
                            for (ValueMetaInterface field : fields.getValueMetaList()) {
                                String key = MetaInjectDialog.this.buildStepFieldKey((String)prevStepName, field.getName());
                                fieldMap.put(key, new SourceStepField((String)prevStepName, field.getName()));
                            }
                        }
                        Object[] sourceFields = fieldMap.keySet().toArray(new String[fieldMap.size()]);
                        Arrays.sort(sourceFields);
                        String constant = source != null && source.getStepname() == null ? source.getField() : "";
                        EnterSelectionDialog selectSourceField = new EnterSelectionDialog(MetaInjectDialog.this.shell, (String[])sourceFields, BaseMessages.getString((Class)PKG, (String)"MetaInjectDialog.SourceFieldDialog.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"MetaInjectDialog.SourceFieldDialog.Label", (String[])new String[0]), constant, (VariableSpace)MetaInjectDialog.this.transMeta);
                        if (source != null) {
                            if (source.getStepname() != null && !Utils.isEmpty((CharSequence)source.getStepname())) {
                                String key = MetaInjectDialog.this.buildStepFieldKey(source.getStepname(), source.getField());
                                selectSourceField.setCurrentValue(key);
                                int index = Const.indexOfString((String)key, (String[])sourceFields);
                                if (index >= 0) {
                                    selectSourceField.setSelectedNrs(new int[]{index});
                                }
                            } else {
                                selectSourceField.setCurrentValue(source.getField());
                            }
                        }
                        if ((selectedStepField = selectSourceField.open()) != null) {
                            SourceStepField newSource = (SourceStepField)fieldMap.get(selectedStepField);
                            if (newSource == null) {
                                newSource = new SourceStepField(null, selectedStepField);
                                item.setText(2, MetaInjectDialog.CONST_VALUE);
                                item.setText(3, selectedStepField);
                            } else {
                                item.setText(2, newSource.getStepname());
                                item.setText(3, newSource.getField());
                            }
                            MetaInjectDialog.this.targetSourceMapping.put(target, newSource);
                        } else {
                            item.setText(2, "");
                            item.setText(3, "");
                            MetaInjectDialog.this.targetSourceMapping.remove(target);
                        }
                    }
                }
                catch (Exception e) {
                    new ErrorDialog(MetaInjectDialog.this.shell, "Oops", "Unexpected Error", e);
                }
            }
        });
        FormData fdInjectComp = new FormData();
        fdInjectComp.left = new FormAttachment(0, 0);
        fdInjectComp.top = new FormAttachment(0, 0);
        fdInjectComp.right = new FormAttachment(100, 0);
        fdInjectComp.bottom = new FormAttachment(100, 0);
        this.wInjectComp.setLayoutData((Object)fdInjectComp);
        this.wInjectComp.pack();
        Rectangle bounds = this.wInjectComp.getBounds();
        this.wInjectSComp.setContent((Control)this.wInjectComp);
        this.wInjectSComp.setExpandHorizontal(true);
        this.wInjectSComp.setExpandVertical(true);
        this.wInjectSComp.setMinWidth(bounds.width);
        this.wInjectSComp.setMinHeight(bounds.height);
        this.wInjectTab.setControl((Control)this.wInjectSComp);
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.injectTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, true, null);
        this.injectTransMeta.clearChanged();
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.injectTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname));
        this.injectTransMeta.clearChanged();
    }

    private boolean loadTransformation() throws KettleException {
        String filename = this.wPath.getText();
        boolean isEmptyFilename = Utils.isEmpty((CharSequence)filename);
        this.specificationMethod = this.repository != null ? (isEmptyFilename && this.referenceObjectId != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE : ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) : ObjectLocationSpecificationMethod.FILENAME;
        switch (this.specificationMethod) {
            case FILENAME: {
                if (isEmptyFilename) {
                    return false;
                }
                if (!filename.endsWith(".ktr")) {
                    filename = filename + ".ktr";
                    this.wPath.setText(filename);
                }
                this.loadFileTrans(filename);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                if (isEmptyFilename) {
                    return false;
                }
                if (filename.endsWith(".ktr")) {
                    filename = filename.replace(".ktr", "");
                    this.wPath.setText(filename);
                }
                String realTransname = transPath = this.transMeta.environmentSubstitute(filename);
                String realDirectory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    realTransname = transPath.substring(index + 1);
                    realDirectory = transPath.substring(0, index);
                }
                if (Utils.isEmpty((CharSequence)realDirectory) || Utils.isEmpty((CharSequence)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToFindRepositoryDirectory)", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                if (this.referenceObjectId == null) {
                    return false;
                }
                this.injectTransMeta = this.repository.loadTransformation(this.referenceObjectId, null);
                this.injectTransMeta.clearChanged();
                break;
            }
        }
        return true;
    }

    public void setActive() {
        boolean outputCapture = !Utils.isEmpty((CharSequence)this.wSourceStep.getText());
        this.wSourceFields.setEnabled(outputCapture);
        boolean streaming = !Utils.isEmpty((CharSequence)this.wStreamingSourceStep.getText());
        this.wStreamingTargetStep.setEnabled(streaming);
        this.wlStreamingTargetStep.setEnabled(streaming);
    }

    private void getByReferenceData(RepositoryElementMetaInterface transInf) {
        String path = DialogUtils.getPath((String)this.transMeta.getRepositoryDirectory().getPath(), (String)transInf.getRepositoryDirectory().getPath());
        String fullPath = Const.NVL((String)path, (String)"") + "/" + Const.NVL((String)transInf.getName(), (String)"");
        this.wPath.setText(fullPath);
    }

    public void getData() {
        this.specificationMethod = this.metaInjectMeta.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wPath.setText(Const.NVL((String)this.metaInjectMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                String fullPath = Const.NVL((String)this.metaInjectMeta.getDirectoryPath(), (String)"") + "/" + Const.NVL((String)this.metaInjectMeta.getTransName(), (String)"");
                this.wPath.setText(fullPath);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.metaInjectMeta.getTransObjectId();
                this.getByReferenceData(this.referenceObjectId);
                break;
            }
        }
        this.wSourceStep.setText(Const.NVL((String)this.metaInjectMeta.getSourceStepName(), (String)""));
        int rownr = 0;
        for (MetaInjectOutputField field : this.metaInjectMeta.getSourceOutputFields()) {
            int colnr = 1;
            this.wSourceFields.setText(field.getName(), colnr++, rownr);
            this.wSourceFields.setText(field.getTypeDescription(), colnr++, rownr);
            this.wSourceFields.setText(field.getLength() < 0 ? "" : Integer.toString(field.getLength()), colnr++, rownr);
            this.wSourceFields.setText(field.getPrecision() < 0 ? "" : Integer.toString(field.getPrecision()), colnr++, rownr);
            ++rownr;
        }
        this.wTargetFile.setText(Const.NVL((String)this.metaInjectMeta.getTargetFile(), (String)""));
        this.wNoExecution.setSelection(!this.metaInjectMeta.isNoExecution());
        this.wStreamingSourceStep.setText(Const.NVL(this.metaInjectMeta.getStreamSourceStep() == null ? null : this.metaInjectMeta.getStreamSourceStep().getName(), (String)""));
        this.wStreamingTargetStep.setText(Const.NVL((String)this.metaInjectMeta.getStreamTargetStepname(), (String)""));
        this.setActive();
        this.refreshTree();
        this.wTabFolder.setSelection(0);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    protected String buildStepFieldKey(String stepname, String field) {
        return stepname + " : " + field;
    }

    private void refreshTree() {
        try {
            this.loadTransformation();
            this.treeItemTargetMap = new HashMap<TreeItem, TargetStepAttribute>();
            this.wTree.removeAll();
            TreeItem transItem = new TreeItem(this.wTree, 0);
            transItem.setExpanded(true);
            transItem.setText(this.injectTransMeta.getName());
            ArrayList<StepMeta> injectSteps = new ArrayList<StepMeta>();
            for (StepMeta stepMeta : this.injectTransMeta.getUsedSteps()) {
                StepMetaInterface meta = stepMeta.getStepMetaInterface();
                if (meta.getStepMetaInjectionInterface() == null && !BeanInjectionInfo.isInjectionSupported(meta.getClass())) continue;
                injectSteps.add(stepMeta);
            }
            Collections.sort(injectSteps);
            for (StepMeta stepMeta : injectSteps) {
                TreeItem stepItem = new TreeItem(transItem, 0);
                stepItem.setText(stepMeta.getName());
                stepItem.setExpanded(true);
                StepMetaInterface metaInterface = stepMeta.getStepMetaInterface();
                if (BeanInjectionInfo.isInjectionSupported(metaInterface.getClass())) {
                    this.processNewMDIDescription(stepMeta, stepItem, metaInterface);
                    continue;
                }
                this.processOldMDIDescription(stepMeta, stepItem, metaInterface.getStepMetaInjectionInterface());
            }
        }
        catch (Throwable transItem) {
            // empty catch block
        }
        for (TreeItem item : this.wTree.getItems()) {
            this.expandItemAndChildren(item);
        }
        if (this.injectTransMeta != null) {
            Object[] sourceSteps = this.injectTransMeta.getStepNames();
            Arrays.sort(sourceSteps);
            this.wSourceStep.setItems((String[])sourceSteps);
            this.wStreamingTargetStep.setItems((String[])sourceSteps);
        }
    }

    private void processOldMDIDescription(StepMeta stepMeta, TreeItem stepItem, StepMetaInjectionInterface injection) throws KettleException {
        List entries = injection.getStepInjectionMetadataEntries();
        for (final StepInjectionMetaEntry entry : entries) {
            if (entry.getValueType() != 0) {
                TreeItem entryItem = new TreeItem(stepItem, 0);
                entryItem.setText(entry.getKey());
                entryItem.setText(1, entry.getDescription());
                TargetStepAttribute target = new TargetStepAttribute(stepMeta.getName(), entry.getKey(), false);
                this.treeItemTargetMap.put(entryItem, target);
                SourceStepField source = this.targetSourceMapping.get(target);
                if (source == null) continue;
                entryItem.setText(2, Const.NVL((String)source.getStepname(), (String)""));
                entryItem.setText(3, Const.NVL((String)source.getField(), (String)""));
                continue;
            }
            TreeItem listsItem = new TreeItem(stepItem, 0);
            listsItem.setText(entry.getKey());
            listsItem.setText(1, entry.getDescription());
            StepInjectionMetaEntry listEntry = (StepInjectionMetaEntry)entry.getDetails().get(0);
            listsItem.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    System.out.println(entry.getKey() + " - " + entry.getDescription());
                }
            });
            for (StepInjectionMetaEntry me : listEntry.getDetails()) {
                TreeItem treeItem = new TreeItem(listsItem, 0);
                treeItem.setText(me.getKey());
                treeItem.setText(1, me.getDescription());
                TargetStepAttribute target = new TargetStepAttribute(stepMeta.getName(), me.getKey(), true);
                this.treeItemTargetMap.put(treeItem, target);
                SourceStepField source = this.targetSourceMapping.get(target);
                if (source == null) continue;
                treeItem.setText(2, Const.NVL((String)source.getStepname(), (String)""));
                treeItem.setText(3, Const.NVL((String)source.getField(), (String)""));
            }
        }
    }

    private void processNewMDIDescription(StepMeta stepMeta, TreeItem stepItem, StepMetaInterface metaInterface) {
        BeanInjectionInfo stepInjectionInfo = new BeanInjectionInfo(metaInterface.getClass());
        for (BeanInjectionInfo.Group gr : stepInjectionInfo.getGroups()) {
            TreeItem groupItem;
            boolean rootGroup = StringUtils.isEmpty((String)gr.getName());
            if (!rootGroup) {
                groupItem = new TreeItem(stepItem, 0);
                groupItem.setText(gr.getName());
                groupItem.setText(1, gr.getDescription());
            } else {
                groupItem = null;
            }
            for (BeanInjectionInfo.Property property : gr.getGroupProperties()) {
                TreeItem treeItem = new TreeItem(rootGroup ? stepItem : groupItem, 0);
                treeItem.setText(property.getName());
                treeItem.setText(1, property.getDescription());
                TargetStepAttribute target = new TargetStepAttribute(stepMeta.getName(), property.getName(), !rootGroup);
                this.treeItemTargetMap.put(treeItem, target);
                SourceStepField source = this.targetSourceMapping.get(target);
                if (source == null) continue;
                treeItem.setText(2, Const.NVL((String)(source.getStepname() == null ? CONST_VALUE : source.getStepname()), (String)""));
                treeItem.setText(3, Const.NVL((String)source.getField(), (String)""));
            }
        }
    }

    private void expandItemAndChildren(TreeItem item) {
        item.setExpanded(true);
        for (TreeItem item2 : item.getItems()) {
            this.expandItemAndChildren(item2);
        }
    }

    private void cancel() {
        this.stepname = null;
        this.metaInjectMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.loadTransformation();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.specificationMethod = this.repository != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME : ObjectLocationSpecificationMethod.FILENAME;
        this.metaInjectMeta.setSpecificationMethod(this.specificationMethod);
        switch (this.specificationMethod) {
            case FILENAME: {
                this.metaInjectMeta.setFileName(this.wPath.getText());
                this.metaInjectMeta.setDirectoryPath(null);
                this.metaInjectMeta.setTransName(null);
                this.metaInjectMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                String transName = transPath = this.wPath.getText();
                String directory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    transName = transPath.substring(index + 1);
                    directory = transPath.substring(0, index);
                }
                this.metaInjectMeta.setDirectoryPath(directory);
                this.metaInjectMeta.setTransName(transName);
                this.metaInjectMeta.setFileName(null);
                this.metaInjectMeta.setTransObjectId(null);
                break;
            }
        }
        this.metaInjectMeta.setSourceStepName(this.wSourceStep.getText());
        this.metaInjectMeta.setSourceOutputFields(new ArrayList<MetaInjectOutputField>());
        for (int i = 0; i < this.wSourceFields.nrNonEmpty(); ++i) {
            TableItem item = this.wSourceFields.getNonEmpty(i);
            int colIndex = 1;
            String name = item.getText(colIndex++);
            int type = ValueMetaFactory.getIdForValueMeta((String)item.getText(colIndex++));
            int length = Const.toInt((String)item.getText(colIndex++), (int)-1);
            int precision = Const.toInt((String)item.getText(colIndex++), (int)-1);
            this.metaInjectMeta.getSourceOutputFields().add(new MetaInjectOutputField(name, type, length, precision));
        }
        this.metaInjectMeta.setTargetFile(this.wTargetFile.getText());
        this.metaInjectMeta.setNoExecution(!this.wNoExecution.getSelection());
        StepMeta streamSourceStep = this.transMeta.findStep(this.wStreamingSourceStep.getText());
        this.metaInjectMeta.setStreamSourceStep(streamSourceStep);
        this.metaInjectMeta.setStreamSourceStepname(streamSourceStep != null ? streamSourceStep.getName() : "");
        this.metaInjectMeta.setStreamTargetStepname(this.wStreamingTargetStep.getText());
        this.metaInjectMeta.setTargetSourceMapping(this.targetSourceMapping);
        this.metaInjectMeta.setChanged(true);
        this.dispose();
    }

    private void getByReferenceData(ObjectId transObjectId) {
        try {
            if (this.repository == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.NotConnectedToRepository.Message", (String[])new String[0]));
            }
            RepositoryObject transInf = this.repository.getObjectInformation(transObjectId, RepositoryObjectType.JOB);
            if (transInf != null) {
                this.getByReferenceData((RepositoryElementMetaInterface)transInf);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

