/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.controller;

import java.io.Serializable;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityProvider;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class AbsContextMenuController
extends AbstractXulEventHandler
implements IUISupportController,
Serializable {
    private static final long serialVersionUID = 8878231461011554114L;
    private IAbsSecurityProvider service;
    private boolean isAllowed = false;
    private BindingFactory bf;

    public void init(Repository repository) throws ControllerInitializationException {
        try {
            if (repository.hasService(IAbsSecurityProvider.class)) {
                this.service = (IAbsSecurityProvider)repository.getService(IAbsSecurityProvider.class);
                this.bf = new DefaultBindingFactory();
                this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
                if (this.bf != null) {
                    this.createBindings();
                }
                this.setAllowed(this.allowedActionsContains(this.service, "org.pentaho.repository.create"));
            }
        }
        catch (KettleException e) {
            throw new ControllerInitializationException((Throwable)e);
        }
    }

    private void createBindings() {
        this.bf.createBinding((Object)this, "allowed", "file-context-rename", "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "allowed", "file-context-delete", "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "allowed", "folder-context-create", "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "allowed", "folder-context-rename", "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "allowed", "folder-context-delete", "!disabled", new BindingConvertor[0]);
    }

    public String getName() {
        return "contextMenuController";
    }

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public void setAllowed(boolean isAllowed) {
        this.isAllowed = isAllowed;
        this.firePropertyChange("allowed", null, isAllowed);
    }

    private boolean allowedActionsContains(IAbsSecurityProvider service, String action) throws KettleException {
        List<String> allowedActions = service.getAllowedActions("org.pentaho");
        for (String actionName : allowedActions) {
            if (action == null || !action.equals(actionName)) continue;
            return true;
        }
        return false;
    }
}

