/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.controller;

import java.io.Serializable;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityProvider;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.ClustersController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UICluster;

public class AbsClustersController
extends ClustersController
implements Serializable {
    private static final long serialVersionUID = -8073486897745053639L;
    IAbsSecurityProvider service;
    boolean isAllowed = false;

    protected boolean doLazyInit() {
        boolean superSucceeded = super.doLazyInit();
        if (!superSucceeded) {
            return false;
        }
        try {
            if (this.repository.hasService(IAbsSecurityProvider.class)) {
                this.service = (IAbsSecurityProvider)this.repository.getService(IAbsSecurityProvider.class);
                this.setAllowed(this.allowedActionsContains(this.service, "org.pentaho.repository.create"));
            }
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public void setAllowed(boolean isAllowed) {
        this.isAllowed = isAllowed;
        this.firePropertyChange("allowed", null, isAllowed);
    }

    public void setEnableButtons(List<UICluster> clusters) {
        if (this.isAllowed) {
            super.setEnableButtons(clusters);
        } else {
            this.enableButtons(false, false, false);
        }
    }

    private boolean allowedActionsContains(IAbsSecurityProvider service, String action) throws KettleException {
        List<String> allowedActions = service.getAllowedActions("org.pentaho");
        for (String actionName : allowedActions) {
            if (action == null || !action.equals(actionName)) continue;
            return true;
        }
        return false;
    }
}

