/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import com.pentaho.di.services.FileVersioningConfiguration;
import com.pentaho.di.services.PentahoDiPlugin;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.BaseRepositorySecurityProvider;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.pur.IUserRoleListChangeListener;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.di.repository.pur.UserRoleDelegate;
import org.pentaho.di.repository.pur.UserRoleListDelegate;
import org.pentaho.platform.util.RepositoryPathEncoder;

public class PurRepositorySecurityProvider
extends BaseRepositorySecurityProvider
implements RepositorySecurityProvider,
IUserRoleListChangeListener,
Serializable {
    private static final long serialVersionUID = -1774142691342083217L;
    private PurRepository repository;
    private UserRoleListDelegate userRoleListDelegate;
    private UserRoleDelegate userRoleDelegate;
    private static final Log logger = LogFactory.getLog(PurRepositorySecurityProvider.class);
    FileVersioningConfiguration lastFileVersioningConfiguration;
    String lastFileVersioningPath;
    Date lastVersioningTime;

    public PurRepositorySecurityProvider(PurRepository repository, PurRepositoryMeta repositoryMeta, IUser user, ServiceManager serviceManager) {
        super((RepositoryMeta)repositoryMeta, user);
        this.repository = repository;
        this.userRoleListDelegate = new UserRoleListDelegate(repositoryMeta, user, logger, serviceManager);
        this.setUserRoleListDelegate(this.userRoleListDelegate);
    }

    public PurRepository getRepository() {
        return this.repository;
    }

    public boolean isVersionCommentMandatory() {
        return ((PurRepositoryMeta)this.repositoryMeta).isVersionCommentMandatory();
    }

    public boolean isLockingPossible() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean allowsVersionComments(String fullPath) {
        FileVersioningConfiguration versioningConfiguration;
        try {
            versioningConfiguration = this.callVersioningService(fullPath);
        }
        catch (KettleException e) {
            e.printStackTrace();
            return false;
        }
        return versioningConfiguration.isVersionCommentEnabled();
    }

    public String[] getUserLogins() throws KettleException {
        List<String> users = this.userRoleListDelegate.getAllUsers();
        if (users != null && users.size() > 0) {
            String[] returnValue = new String[users.size()];
            users.toArray(returnValue);
            return returnValue;
        }
        return null;
    }

    public List<String> getAllRoles() throws KettleException {
        return this.userRoleListDelegate.getAllRoles();
    }

    public List<String> getAllUsers() throws KettleException {
        return this.userRoleListDelegate.getAllUsers();
    }

    public UserRoleDelegate getUserRoleDelegate() {
        return this.userRoleDelegate;
    }

    public void setUserRoleDelegate(UserRoleDelegate userRoleDelegate) {
        this.userRoleDelegate = userRoleDelegate;
        this.userRoleDelegate.addUserRoleListChangeListener(this);
    }

    public void setUserRoleListDelegate(UserRoleListDelegate userRoleListDelegate) {
        this.userRoleListDelegate = userRoleListDelegate;
    }

    public UserRoleListDelegate getUserRoleListDelegate() {
        return this.userRoleListDelegate;
    }

    @Override
    public void onChange() {
        this.userRoleListDelegate.updateUserRoleList();
    }

    public static Log getLogger() {
        return logger;
    }

    public boolean isVersioningEnabled(String fullPath) {
        FileVersioningConfiguration versioningConfiguration;
        try {
            versioningConfiguration = this.callVersioningService(fullPath);
        }
        catch (KettleException e) {
            e.printStackTrace();
            return false;
        }
        return versioningConfiguration.isVersioningEnabled();
    }

    private synchronized FileVersioningConfiguration callVersioningService(String fullPath) throws KettleException {
        if (fullPath.equals(this.lastFileVersioningPath) && new Date().getTime() - this.lastVersioningTime.getTime() < 2000L) {
            return this.lastFileVersioningConfiguration;
        }
        PentahoDiPlugin.PurRepositoryPluginApiRevision servicePort = (PentahoDiPlugin.PurRepositoryPluginApiRevision)this.repository.getService(PentahoDiPlugin.PurRepositoryPluginApiRevision.class);
        PentahoDiPlugin.PurRepositoryPluginApiRevision.PathIdVersioningConfiguration fileVersioningConfigurationService = servicePort.pathIdVersioningConfiguration(RepositoryPathEncoder.encodeRepositoryPath((String)fullPath));
        this.lastFileVersioningConfiguration = fileVersioningConfigurationService.getAsFileVersioningConfigurationXml();
        this.lastVersioningTime = new Date();
        this.lastFileVersioningPath = fullPath;
        return this.lastFileVersioningConfiguration;
    }
}

