/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.util.Date;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;

public abstract class AbstractDelegate {
    protected static final String PROP_NAME = "NAME";
    protected static final String PROP_DESCRIPTION = "DESCRIPTION";
    protected LogChannelInterface log = LogChannel.GENERAL;

    protected String sanitizeNodeName(String name) {
        StringBuffer result = new StringBuffer(30);
        block4: for (char c : name.toCharArray()) {
            switch (c) {
                case '/': 
                case ':': {
                    result.append('-');
                    continue block4;
                }
                case '(': 
                case ')': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    result.append('_');
                    continue block4;
                }
                default: {
                    if (!Character.isLetterOrDigit(c)) continue block4;
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    protected String getString(DataNode node, String name) {
        if (node.hasProperty(name)) {
            return node.getProperty(name).getString();
        }
        return "";
    }

    protected int getInt(DataNode node, String name) {
        if (node.hasProperty(name)) {
            return (int)node.getProperty(name).getLong();
        }
        return 0;
    }

    protected long getLong(DataNode node, String name) {
        if (node.hasProperty(name)) {
            return node.getProperty(name).getLong();
        }
        return 0L;
    }

    protected Date getDate(DataNode node, String name) {
        if (node.hasProperty(name)) {
            return node.getProperty(name).getDate();
        }
        return null;
    }

    protected boolean getBoolean(DataNode node, String name) {
        return this.getBoolean(node, name, false);
    }

    protected boolean getBoolean(DataNode node, String name, boolean defaultValue) {
        if (node.hasProperty(name)) {
            return node.getProperty(name).getBoolean();
        }
        return defaultValue;
    }

    protected String setNull(String value) {
        String response = value;
        if (value == null) {
            response = "";
        }
        return response;
    }

    public abstract DataNode elementToDataNode(RepositoryElementInterface var1) throws KettleException;

    public boolean equals(RepositoryElementInterface first, RepositoryElementInterface second) {
        try {
            return this.elementToDataNode(first).equals((Object)this.elementToDataNode(second));
        }
        catch (KettleException e) {
            return false;
        }
    }
}

