/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.google.common.annotations.VisibleForTesting;
import com.pentaho.di.messages.Messages;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.platform.util.RepositoryPathEncoder;

public class RepositoryCleanupUtil {
    public static Client client;
    public static boolean testMode;
    private final String URL = "url";
    private final String USER = "user";
    private final String PASS = "password";
    private final String VER_COUNT = "versionCount";
    private final String DEL_DATE = "purgeBeforeDate";
    private final String PURGE_FILES = "purgeFiles";
    private final String PURGE_REV = "purgeRevisions";
    private final String LOG_LEVEL = "logLevel";
    private final String LOG_FILE = "logFileName";
    private final String PURGE_SHARED = "purgeSharedObjects";
    private final String FILE_FILTER = "fileFilter";
    private final String SERVICE_NAME = "purge";
    private final String BASE_PATH = "/plugin/pur-repository-plugin/api/purge";
    private final String AUTHENTICATION = "/api/authorization/action/isauthorized?authAction=";
    private final String purgeBeforeDateFormat = "MM/dd/yyyy";
    private final String logFileNameDateFormat = "YYYYMMdd-HHmmss";
    private final String DEFAULT_LOG_FILE_PREFIX = "purge-utility-log-";
    private final String OPTION_PREFIX = "-";
    private final String NEW_LINE = "\n";
    private String url = null;
    private String username = null;
    private String password = null;
    private int verCount = -1;
    private String delFrom = null;
    private String logLevel = null;
    private boolean purgeFiles = false;
    private boolean purgeRev = false;
    private boolean purgeShared = false;
    private String logFile = null;
    private String fileFilter;
    private String repositoryPath;

    public static void main(String[] args) {
        try {
            new RepositoryCleanupUtil().purge(args);
        }
        catch (Exception e) {
            RepositoryCleanupUtil.writeOut(e);
        }
        RepositoryCleanupUtil.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(String[] options) {
        FormDataMultiPart form = null;
        try {
            Map<String, String> parameters = this.parseExecutionOptions(options);
            this.validateParameters(parameters);
            this.authenticateLoginCredentials();
            String serviceURL = this.createPurgeServiceURL();
            form = this.createParametersForm();
            WebResource resource = client.resource(serviceURL);
            ClientResponse response = (ClientResponse)resource.type("multipart/form-data").post(ClientResponse.class, (Object)form);
            if (response != null && response.getStatus() == 200) {
                String resultLog = (String)response.getEntity(String.class);
                String logName = this.writeLog(resultLog);
                RepositoryCleanupUtil.writeOut(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0001.OP_SUCCESS", new Object[]{logName}), false);
            } else {
                RepositoryCleanupUtil.writeOut(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0001.OP_FAILURE"), true);
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else if (!(e instanceof NormalExitException)) {
                e.printStackTrace();
            }
        }
        finally {
            if (client != null) {
                client.destroy();
            }
            if (form != null) {
                form.cleanup();
            }
        }
    }

    private Map<String, String> parseExecutionOptions(String[] args) throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        try {
            for (String arg : args) {
                String value;
                String param;
                int equalsPos = arg.indexOf("=");
                if (equalsPos == -1) {
                    param = arg;
                    value = "true";
                } else {
                    param = arg.substring(0, equalsPos);
                    value = arg.substring(equalsPos + 1, arg.length());
                }
                arguments.put(param, value);
            }
        }
        catch (Exception e) {
            RepositoryCleanupUtil.writeOut(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0002.ERROR_PROC_PARAMS"), true);
        }
        if (arguments.size() == 0) {
            RepositoryCleanupUtil.writeOut(this.printHelp(), true);
        }
        return arguments;
    }

    private void validateParameters(Map<String, String> arguments) throws Exception {
        String aUrl = arguments.get("-url");
        String aUser = arguments.get("-user");
        String aPassword = arguments.get("-password");
        String aVerCount = arguments.get("-versionCount");
        String aDelFrom = arguments.get("-purgeBeforeDate");
        String aPurgeFiles = arguments.get("-purgeFiles");
        String aPurgeRev = arguments.get("-purgeRevisions");
        String aPurgeShared = arguments.get("-purgeSharedObjects");
        String aLogLevel = arguments.get("-logLevel");
        String aLogFile = arguments.get("-logFileName");
        StringBuffer errors = new StringBuffer();
        boolean isValidOperationSelected = false;
        this.fileFilter = "*.kjb|*.ktr";
        this.repositoryPath = "/";
        this.purgeShared = false;
        if (!(aLogLevel == null || aLogLevel.equals("DEBUG") || aLogLevel.equals("ERROR") || aLogLevel.equals("FATAL") || aLogLevel.equals("INFO") || aLogLevel.equals("OFF") || aLogLevel.equals("TRACE") || aLogLevel.equals("WARN"))) {
            errors.append("-logLevel=" + aLogLevel + " " + Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0003.INVALID_LOGLEVEL") + "\n");
        } else {
            this.logLevel = aLogLevel;
        }
        if (aLogFile != null) {
            File f = new File(aLogFile);
            if (f.exists() && f.isDirectory()) {
                errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0004.FOLDER_EXISTS", new Object[]{"-logFileName"}) + "\n");
            }
            this.logFile = aLogFile;
        }
        if (aUrl == null) {
            errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0005.MISSING_PARAM", new Object[]{"-url"}) + "\n");
        } else {
            this.url = aUrl;
        }
        if (aUser == null) {
            errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0005.MISSING_PARAM", new Object[]{"-user"}) + "\n");
        } else {
            this.username = aUser;
        }
        if (aPassword == null) {
            errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0005.MISSING_PARAM", new Object[]{"-password"}) + "\n");
        } else {
            this.password = aPassword;
        }
        if (aPurgeFiles != null) {
            if (aPurgeFiles.equalsIgnoreCase(Boolean.TRUE.toString()) || aPurgeFiles.equalsIgnoreCase(Boolean.FALSE.toString())) {
                this.purgeFiles = Boolean.parseBoolean(aPurgeFiles);
                isValidOperationSelected = true;
            } else {
                errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0006.INVALID_BOOLEAN", new Object[]{"-purgeFiles=" + aPurgeFiles}) + "\n");
            }
        }
        if (aPurgeRev != null) {
            if (aPurgeRev.equalsIgnoreCase(Boolean.TRUE.toString()) || aPurgeRev.equalsIgnoreCase(Boolean.FALSE.toString())) {
                if (isValidOperationSelected) {
                    errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0010.INVALID_COMBINATION_OF_PARAMS") + "\n");
                } else {
                    this.purgeRev = Boolean.parseBoolean(aPurgeRev);
                    isValidOperationSelected = true;
                }
            } else {
                errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0006.INVALID_BOOLEAN", new Object[]{"-purgeRevisions=" + aPurgeRev}) + "\n");
            }
        }
        if (aPurgeShared != null) {
            if (Boolean.parseBoolean(aPurgeFiles) != Boolean.TRUE) {
                errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0014.INVALID_PURGE_SHARED"));
            } else {
                this.purgeShared = Boolean.parseBoolean(aPurgeShared);
            }
        }
        if (aDelFrom != null) {
            if (isValidOperationSelected) {
                errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0010.INVALID_COMBINATION_OF_PARAMS") + "\n");
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                sdf.setLenient(false);
                try {
                    sdf.parse(aDelFrom);
                    this.delFrom = aDelFrom;
                    isValidOperationSelected = true;
                }
                catch (ParseException e) {
                    errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0008.IMPROPERLY_FORMATTED_DATE", new Object[]{"-purgeBeforeDate=" + aDelFrom, "MM/dd/yyyy"}) + "\n");
                }
            }
        }
        if (aVerCount != null) {
            if (isValidOperationSelected) {
                errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0010.INVALID_COMBINATION_OF_PARAMS") + "\n");
            } else {
                try {
                    this.verCount = Integer.parseInt(aVerCount);
                    isValidOperationSelected = true;
                }
                catch (NumberFormatException e) {
                    errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0009.INVALID_INTEGER", new Object[]{"-versionCount=" + aVerCount}) + "\n");
                }
            }
        }
        if (!isValidOperationSelected) {
            errors.append(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0013.MISSING_OPERATION") + "\n");
        }
        if (errors.length() != 0) {
            errors.insert(0, "\n\n" + Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0011.ERRORS_HEADER") + "\n");
            throw new Exception(errors.toString());
        }
    }

    @VisibleForTesting
    void authenticateLoginCredentials() throws Exception {
        WebResource resource;
        String response;
        KettleClientEnvironment.init();
        if (client == null) {
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
            client = Client.create((ClientConfig)clientConfig);
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, Encr.decryptPasswordOptionallyEncrypted((String)this.password)));
        }
        if (!(response = (String)(resource = client.resource(this.url + "/api/authorization/action/isauthorized?authAction=" + "org.pentaho.security.administerSecurity")).get(String.class)).equals("true")) {
            throw new Exception(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.ERROR_0012.ACCESS_DENIED"));
        }
    }

    private String createPurgeServiceURL() throws Exception {
        StringBuffer service = new StringBuffer();
        service.append(this.url);
        service.append("/plugin/pur-repository-plugin/api/purge");
        service.append("/");
        String path = RepositoryPathEncoder.encodeRepositoryPath((String)this.repositoryPath);
        path = RepositoryPathEncoder.encode((String)path);
        service.append(path + "/");
        service.append("purge");
        return service.toString();
    }

    private FormDataMultiPart createParametersForm() {
        FormDataMultiPart form = new FormDataMultiPart();
        if (this.verCount != -1 && !this.purgeRev) {
            form.field("versionCount", (Object)Integer.toString(this.verCount), MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (this.delFrom != null && !this.purgeRev) {
            form.field("purgeBeforeDate", (Object)this.delFrom, MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (this.fileFilter != null) {
            form.field("fileFilter", (Object)this.fileFilter, MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (this.logLevel != null) {
            form.field("logLevel", (Object)this.logLevel, MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (this.purgeFiles) {
            form.field("purgeFiles", (Object)Boolean.toString(this.purgeFiles), MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (this.purgeRev) {
            form.field("purgeRevisions", (Object)Boolean.toString(this.purgeRev), MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (this.purgeShared) {
            form.field("purgeSharedObjects", (Object)Boolean.toString(this.purgeShared), MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        return form;
    }

    private String printHelp() {
        StringBuffer help = new StringBuffer();
        help.append("\n\n" + Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0003.OPTIONS_HEADER"));
        help.append(this.optionHelp("url", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0004.URL_REQUIRED", new Object[]{"url"})));
        help.append(this.optionHelp("user", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0005.USER_REQUIRED", new Object[]{"user"})));
        help.append(this.optionHelp("password", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0006.PASS_REQUIRED", new Object[]{"password"})));
        help.append("\n");
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0008.PARAMS_HELP", new Object[]{"purgeSharedObjects"}), 0, 0));
        help.append(this.optionHelp("versionCount", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0009.VERSIONCOUNT_HELP", new Object[]{"versionCount"})));
        help.append(this.optionHelp("purgeBeforeDate", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0010.DATE_HELP", new Object[]{"purgeBeforeDate"})));
        help.append(this.optionHelp("purgeFiles", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0011.PURGE_FILES_HELP", new Object[]{"purgeFiles"})));
        help.append(this.optionHelp("purgeRevisions", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0012.PURGE_REVS_HELP", new Object[]{"purgeRevisions"})));
        help.append("\n\n" + Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0013.OPTIONAL_PARAMS"));
        help.append(this.optionHelp("logFileName", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0014.LOGFILE_HELP", new Object[]{"purge-utility-log-YYYYMMdd-HHmmss", "YYYYMMdd-HHmmss"})));
        help.append(this.optionHelp("logLevel", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0015.LOGLEVEL_HELP", new Object[]{"logLevel"})));
        help.append(this.optionHelp("purgeSharedObjects", Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0007.PURGE_SHARED", new Object[]{"purgeFiles"})));
        help.append("\n\n" + Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0016.EXAMPLES"));
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0017.EXAMPLE_1", new Object[]{"-url", "-user", "-password", "-purgeFiles"}), 0, 3));
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0018.EXAMPLE_1_DESC"), 3, 3));
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0019.EXAMPLE_2", new Object[]{"-url", "-user", "-password", "-purgeRevisions"}), 0, 3));
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0020.EXAMPLE_2_DESC"), 3, 3));
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0021.EXAMPLE_3", new Object[]{"-url", "-user", "-password", "-purgeBeforeDate"}), 0, 3));
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0022.EXAMPLE_3_DESC"), 3, 3));
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0023.EXAMPLE_4", new Object[]{"-url", "-user", "-password", "-purgeFiles", "-purgeSharedObjects"}), 0, 3));
        help.append(this.indentFormat(Messages.getInstance().getString("REPOSITORY_CLEANUP_UTIL.INFO_0024.EXAMPLE_4_DESC"), 3, 3));
        return help.toString();
    }

    private String optionHelp(String optionName, String descriptionText) {
        int indentFirstLine = 2;
        int indentBalance = Math.min("-".length() + optionName.length() + 4, 10);
        return this.indentFormat("-" + optionName + ": " + descriptionText, indentFirstLine, indentBalance);
    }

    private String indentFormat(String unformattedText, int indentFirstLine, int indentBalance) {
        int maxWidth = 79;
        String leadLine = WordUtils.wrap((String)unformattedText, (int)(79 - indentFirstLine));
        StringBuilder result = new StringBuilder();
        result.append("\n");
        if (leadLine.indexOf("\n") == -1) {
            result.append("\n").append(StringUtils.repeat((String)" ", (int)indentFirstLine)).append(unformattedText);
        } else {
            int lineBreakPoint = leadLine.indexOf("\n");
            String indentString = StringUtils.repeat((String)" ", (int)indentBalance);
            result.append("\n").append(StringUtils.repeat((String)" ", (int)indentFirstLine)).append(leadLine.substring(0, lineBreakPoint));
            String formattedText = WordUtils.wrap((String)unformattedText.substring(lineBreakPoint), (int)(79 - indentBalance));
            for (String line : formattedText.split("\n")) {
                result.append("\n").append(indentString).append(line);
            }
        }
        return result.toString();
    }

    private String writeLog(String message) throws Exception {
        String logName;
        if (this.logFile != null) {
            logName = this.logFile;
        } else {
            SimpleDateFormat df = new SimpleDateFormat("YYYYMMdd-HHmmss");
            logName = "purge-utility-log-" + df.format(new Date()) + ".txt";
        }
        File file = new File(logName);
        FileOutputStream fout = FileUtils.openOutputStream((File)file);
        IOUtils.copy((InputStream)IOUtils.toInputStream((String)message), (OutputStream)fout);
        fout.close();
        return logName;
    }

    private static void writeOut(String message, boolean isError) {
        if (isError) {
            System.err.println(message);
            RepositoryCleanupUtil.exit(1);
        } else {
            System.out.println(message);
        }
    }

    private static void exit(int exitCode) {
        if (testMode) {
            throw new NormalExitException(exitCode);
        }
        System.exit(exitCode);
    }

    private static void writeOut(Throwable t) {
        t.printStackTrace();
        RepositoryCleanupUtil.exit(1);
    }

    public static class NormalExitException
    extends RuntimeException {
        public int exitCode;

        public NormalExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

