/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.IPurgeUtilityLayout;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class PurgeUtilityTextLayout
implements StringLayout,
IPurgeUtilityLayout {
    protected static final int BUF_SIZE = 256;
    protected static final int MAX_CAPACITY = 1024;
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static final String REGEXP = Strings.LINE_SEPARATOR.equals("\n") ? "\n" : Strings.LINE_SEPARATOR + "|\n";
    private Level loggerLogLevel = Level.DEBUG;
    private StringBuffer sbuf = new StringBuffer(256);
    String title = "Log4J Log Messages";

    public PurgeUtilityTextLayout(Level loggerLogLevel) {
        this.loggerLogLevel = loggerLogLevel;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    public Map<String, String> getContentFormat() {
        return null;
    }

    public void activateOptions() {
    }

    @Override
    public String format(LogEvent event) {
        Level logLevel = event.getLevel();
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        this.sbuf.append(LINE_SEP);
        if (this.showTimeColumn()) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            date.setTime(event.getTimeMillis());
            String time = null;
            try {
                time = df.format(date);
            }
            catch (Exception ex) {
                StatusLogger.getLogger().error("Error occured while converting date.", (Throwable)ex);
            }
            this.sbuf.append(time);
        }
        this.sbuf.append("\t");
        this.sbuf.append(ThreadContext.get((String)"currentFile"));
        if (this.showLevelColumn()) {
            this.sbuf.append("\t");
            this.sbuf.append(String.valueOf(event.getLevel()));
        }
        if (this.showCodeLineColumn()) {
            this.sbuf.append("\t");
            this.sbuf.append(ThreadContext.get((String)"codeLine"));
        }
        this.sbuf.append("\t");
        this.sbuf.append(event.getMessage());
        return this.sbuf.toString();
    }

    public byte[] getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.title);
        return sbuf.toString().getBytes(StandardCharsets.UTF_8);
    }

    public byte[] toByteArray(LogEvent event) {
        return this.format(event).getBytes(StandardCharsets.UTF_8);
    }

    public String toSerializable(LogEvent event) {
        return this.format(event);
    }

    public byte[] getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("End of Log");
        return sbuf.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean ignoresThrowable() {
        return true;
    }

    private boolean showCodeLineColumn() {
        return Level.DEBUG.isMoreSpecificThan(this.loggerLogLevel);
    }

    private boolean showTimeColumn() {
        return Level.DEBUG.isMoreSpecificThan(this.loggerLogLevel);
    }

    private boolean showLevelColumn() {
        return true;
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public void encode(LogEvent source, ByteBufferDestination destination) {
    }
}

