/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.IPurgeUtilityLogger;
import com.pentaho.di.purge.PurgeUtilityLog;
import java.io.OutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class PurgeUtilityLogger
implements IPurgeUtilityLogger {
    private static ThreadLocal<PurgeUtilityLogger> purgeUtilityLogger = new ThreadLocal();
    private static ThreadLocal<PurgeUtilityLog> purgeUtilityLog = new ThreadLocal();
    private boolean isFormalLogger;
    static final String CODE_LINE = "codeLine";

    private PurgeUtilityLogger() {
        this.isFormalLogger = false;
        purgeUtilityLog.set(new PurgeUtilityLog());
    }

    private PurgeUtilityLogger(OutputStream outputStream, String purgePath, Level logLevel) {
        purgeUtilityLog.set(new PurgeUtilityLog(outputStream, purgePath, logLevel));
        this.isFormalLogger = true;
        this.getPurgeUtilityLog().setCurrentFilePath(this.getPurgeUtilityLog().getPurgePath());
        this.info("Start Purge Utility");
    }

    public static void createNewInstance(OutputStream outputStream, String purgePath, Level logLevel) {
        purgeUtilityLogger.set(new PurgeUtilityLogger(outputStream, purgePath, logLevel));
    }

    public static PurgeUtilityLogger getPurgeUtilityLogger() {
        if (purgeUtilityLogger.get() == null) {
            purgeUtilityLogger.set(new PurgeUtilityLogger());
        }
        return purgeUtilityLogger.get();
    }

    @Override
    public void endJob() {
        if (this.isFormalLogger) {
            this.getPurgeUtilityLog().setCurrentFilePath(this.getPurgeUtilityLog().getPurgePath());
            this.info("End Purge Utility");
            this.getPurgeUtilityLog().endJob();
        }
    }

    @Override
    public void setCurrentFilePath(String currentFilePath) {
        if (this.isFormalLogger) {
            this.getPurgeUtilityLog().setCurrentFilePath(currentFilePath);
        }
    }

    @Override
    public void info(String s) {
        this.setCodeLine();
        this.getLogger().info(s);
    }

    @Override
    public void error(String s) {
        this.setCodeLine();
        this.getLogger().error(s);
    }

    @Override
    public void debug(String s) {
        this.setCodeLine();
        this.getLogger().debug(s);
    }

    public void warn(String s) {
        this.setCodeLine();
        this.getLogger().debug(s);
    }

    @Override
    public void error(Exception e) {
        this.setCodeLine();
        this.getLogger().error(this.throwableToString(e));
    }

    private PurgeUtilityLog getPurgeUtilityLog() {
        PurgeUtilityLog currentLog = purgeUtilityLog.get();
        if (currentLog == null) {
            throw new IllegalStateException("No job started for current Thread");
        }
        return currentLog;
    }

    private Logger getLogger() {
        return this.getPurgeUtilityLog().getLogger();
    }

    @Override
    public boolean hasLogger() {
        return purgeUtilityLog.get() != null;
    }

    public void debug(Object arg0) {
        this.setCodeLine();
        this.getLogger().debug(arg0);
    }

    public void debug(Object arg0, Throwable arg1) {
        this.setCodeLine();
        this.getLogger().debug(arg0, arg1);
    }

    public void error(Object arg0) {
        this.setCodeLine();
        this.getLogger().error(arg0);
    }

    public void error(Object arg0, Throwable arg1) {
        this.setCodeLine();
        this.getLogger().error(arg0, arg1);
    }

    public void fatal(Object arg0) {
        this.setCodeLine();
        this.getLogger().fatal(arg0);
    }

    public void fatal(Object arg0, Throwable arg1) {
        this.setCodeLine();
        this.getLogger().fatal(arg0, arg1);
    }

    public void info(Object arg0) {
        this.setCodeLine();
        this.getLogger().info(arg0);
    }

    public void info(Object arg0, Throwable arg1) {
        this.setCodeLine();
        this.getLogger().info(arg0, arg1);
    }

    public boolean isDebugEnabled() {
        this.setCodeLine();
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        this.setCodeLine();
        return Level.ERROR.isMoreSpecificThan(this.getLogger().getLevel());
    }

    public boolean isFatalEnabled() {
        this.setCodeLine();
        return Level.FATAL.isMoreSpecificThan(this.getLogger().getLevel());
    }

    public boolean isInfoEnabled() {
        this.setCodeLine();
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        this.setCodeLine();
        return this.getLogger().isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        this.setCodeLine();
        return Level.WARN.isMoreSpecificThan(this.getLogger().getLevel());
    }

    public void trace(Object arg0) {
        this.setCodeLine();
        this.getLogger().trace(arg0);
    }

    public void trace(Object arg0, Throwable arg1) {
        this.setCodeLine();
        this.getLogger().trace(arg0, arg1);
    }

    public void warn(Object arg0) {
        this.setCodeLine();
        this.getLogger().warn(arg0);
    }

    public void warn(Object arg0, Throwable arg1) {
        this.setCodeLine();
        this.getLogger().warn(arg0, arg1);
    }

    private void setCodeLine() {
        for (int stackLevel = 1; stackLevel < Thread.currentThread().getStackTrace().length; ++stackLevel) {
            StackTraceElement ste = Thread.currentThread().getStackTrace()[stackLevel];
            if (ste.getClassName().equals(this.getClass().getName())) continue;
            ThreadContext.put((String)CODE_LINE, (String)(ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber()));
            break;
        }
    }

    private String throwableToString(Throwable e) {
        StringBuilder result = new StringBuilder();
        String LINEFEED = "\n";
        result.append(e.toString());
        result.append("\n");
        int lineCount = 1;
        for (StackTraceElement element : e.getStackTrace()) {
            result.append(element);
            result.append("\n");
            if (lineCount++ >= 20) break;
        }
        return result.toString();
    }
}

