/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.PurgeUtilityHTMLLayout;
import com.pentaho.di.purge.PurgeUtilityTextLayout;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.StringLayout;
import org.pentaho.platform.api.util.LogUtil;

public class PurgeUtilityLog {
    private Logger logger;
    static final String FILE_KEY = "currentFile";
    private OutputStream outputStream;
    private String currentFilePath;
    private String logName;
    private String purgePath;
    private Level logLevel;
    private Appender appender;
    protected static Class layoutClass = PurgeUtilityTextLayout.class;

    PurgeUtilityLog() {
    }

    PurgeUtilityLog(OutputStream outputStream, String purgePath, Level logLevel) {
        this.outputStream = outputStream;
        this.purgePath = purgePath;
        this.logLevel = logLevel;
        this.init();
    }

    private void init() {
        this.logName = "PurgeUtilityLog." + this.getThreadName();
        this.logger = LogManager.getLogger((String)this.logName);
        LogUtil.setLevel((Logger)this.logger, (Level)this.logLevel);
        StringLayout layout = layoutClass == PurgeUtilityHTMLLayout.class ? new PurgeUtilityHTMLLayout(this.logLevel) : new PurgeUtilityTextLayout(this.logLevel);
        layout.setTitle("Purge Utility Log");
        this.appender = LogUtil.makeAppender((String)this.logName, (Writer)new OutputStreamWriter(this.outputStream, Charset.forName("utf-8")), (Layout)((Layout)layout));
        LogUtil.addAppender((Appender)this.appender, (Logger)this.logger, (Level)this.logLevel);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            return LogManager.getLogger((String)Thread.currentThread().getStackTrace()[4].getClassName());
        }
        return this.logger;
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    public void setCurrentFilePath(String currentFilePath) {
        this.currentFilePath = currentFilePath;
        if (currentFilePath != null) {
            ThreadContext.put((String)FILE_KEY, (String)currentFilePath);
        }
    }

    public String getPurgePath() {
        return this.purgePath;
    }

    protected void endJob() {
        try {
            this.outputStream.write(this.appender.getLayout().getFooter());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        LogUtil.removeAppender((Appender)this.appender, (Logger)this.logger);
    }

    private String getThreadName() {
        return Thread.currentThread().getName();
    }
}

