/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.PurgeUtilityLogger;
import com.pentaho.di.purge.PurgeUtilitySpecification;
import com.pentaho.di.purge.UnifiedRepositoryPurgeService;
import com.sun.jersey.multipart.FormDataParam;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.Level;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.util.RepositoryPathEncoder;

@Path(value="/pur-repository-plugin/api/purge")
public class PurgeResource {
    public static final String PATH_SEPARATOR = "/";
    IUnifiedRepository repository;

    public PurgeResource(IUnifiedRepository unifiedRepository) {
        this.repository = unifiedRepository;
    }

    @POST
    @Path(value="{pathId : .+}/purge")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully purged specified target"), @ResponseCode(code=500, condition="Something failed when attempting to purge "), @ResponseCode(code=404, condition="Invalid path")})
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"*/*"})
    public Response doDeleteRevisions(@PathParam(value="pathId") String pathId, @DefaultValue(value="false") @FormDataParam(value="purgeFiles") boolean purgeFiles, @DefaultValue(value="false") @FormDataParam(value="purgeRevisions") boolean purgeRevisions, @DefaultValue(value="false") @FormDataParam(value="purgeSharedObjects") boolean purgeSharedObjects, @DefaultValue(value="-1") @FormDataParam(value="versionCount") int versionCount, @FormDataParam(value="purgeBeforeDate") Date purgeBeforeDate, @DefaultValue(value="*") @FormDataParam(value="fileFilter") String fileFilter, @DefaultValue(value="INFO") @FormDataParam(value="logLevel") String logLevelName) {
        if (versionCount == 0) {
            return Response.serverError().build();
        }
        if (purgeRevisions && (versionCount > 0 || purgeBeforeDate != null)) {
            purgeRevisions = false;
        }
        UnifiedRepositoryPurgeService purgeService = new UnifiedRepositoryPurgeService(this.repository);
        Level logLevel = Level.toLevel((String)logLevelName);
        PurgeUtilitySpecification purgeSpecification = new PurgeUtilitySpecification();
        purgeSpecification.setPath(PurgeResource.idToPath(pathId));
        purgeSpecification.setPurgeFiles(purgeFiles);
        purgeSpecification.setPurgeRevisions(purgeRevisions);
        purgeSpecification.setSharedObjects(purgeSharedObjects);
        purgeSpecification.setVersionCount(versionCount);
        purgeSpecification.setBeforeDate(purgeBeforeDate);
        purgeSpecification.setFileFilter(fileFilter);
        purgeSpecification.setLogLevel(logLevel);
        ByteArrayOutputStream purgeUtilityStream = new ByteArrayOutputStream();
        PurgeUtilityLogger.createNewInstance(purgeUtilityStream, purgeSpecification.getPath(), logLevel);
        try {
            purgeService.doDeleteRevisions(purgeSpecification);
        }
        catch (Exception e) {
            PurgeUtilityLogger.getPurgeUtilityLogger().error(e);
            return Response.ok((Object)this.encodeOutput(purgeUtilityStream), (String)"text/html").build();
        }
        return Response.ok((Object)this.encodeOutput(purgeUtilityStream), (String)"text/html").build();
    }

    public static String idToPath(String pathId) {
        String path = pathId;
        if ((path = RepositoryPathEncoder.decodeRepositoryPath((String)path)) == null || path.trim().isEmpty()) {
            path = "";
        } else if (!path.startsWith(PATH_SEPARATOR)) {
            path = PATH_SEPARATOR + path;
        }
        return path;
    }

    private String encodeOutput(ByteArrayOutputStream purgeUtilityStream) {
        String responseBody = null;
        try {
            responseBody = purgeUtilityStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            responseBody = purgeUtilityStream.toString();
        }
        return responseBody;
    }
}

