/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionXASetTimeoutMessage
extends PacketImpl {
    private int timeoutSeconds;

    public SessionXASetTimeoutMessage(int timeoutSeconds) {
        super((byte)63);
        this.timeoutSeconds = timeoutSeconds;
    }

    public SessionXASetTimeoutMessage() {
        super((byte)63);
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.timeoutSeconds);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.timeoutSeconds = buffer.readInt();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.timeoutSeconds;
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", timeoutSeconds=" + this.timeoutSeconds);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXASetTimeoutMessage)) {
            return false;
        }
        SessionXASetTimeoutMessage other = (SessionXASetTimeoutMessage)obj;
        return this.timeoutSeconds == other.timeoutSeconds;
    }
}

