/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.xml.sax.SAXException;

public class ActionFactory {
    private static final Log logger = LogFactory.getLog(ActionFactory.class);
    public static LinkedHashMap<String, Class> pluginActions = new LinkedHashMap();
    public static String PLUGIN_XML_FILENAME = "pentaho_platform_plugin.xml";
    public static String PLUGIN_ROOT_NODE = "pentaho-plugin";
    public static String PLUGIN_ACTION_DEFINITION_NODE = "action-definition";
    protected static boolean pluginsLoaded = false;

    protected static synchronized void loadPlugins() {
        if (!pluginsLoaded) {
            try {
                ActionFactory factory = new ActionFactory();
                Enumeration<URL> enumer = factory.getClass().getClassLoader().getResources(PLUGIN_XML_FILENAME);
                while (enumer.hasMoreElements()) {
                    URL url = enumer.nextElement();
                    try {
                        SAXReader reader;
                        Document doc;
                        InputStream is = url.openStream();
                        if (is == null || (doc = (reader = ActionFactory.createSafeSaxReader()).read(is)) == null) continue;
                        List nodes = doc.selectNodes(PLUGIN_ROOT_NODE + "/" + PLUGIN_ACTION_DEFINITION_NODE);
                        Iterator it = nodes.iterator();
                        while (it.hasNext()) {
                            try {
                                Element node = (Element)it.next();
                                String className = node.getText();
                                String id = node.attributeValue("id");
                                Class<?> componentClass = Class.forName(className.trim());
                                pluginActions.put(id, componentClass);
                            }
                            catch (Exception e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            pluginsLoaded = true;
        }
    }

    public static ActionDefinition getActionDefinition(Element actionDefDomElement, IActionParameterMgr actionInputProvider) {
        ActionDefinition actionDefinition = null;
        if (!pluginsLoaded) {
            ActionFactory.loadPlugins();
        }
        for (Class actionClass : pluginActions.values()) {
            try {
                Method acceptElementMethod = actionClass.getMethod("accepts", Element.class);
                if (!Boolean.TRUE.equals(acceptElementMethod.invoke(null, actionDefDomElement))) continue;
                Constructor constructor = actionClass.getConstructor(Element.class, IActionParameterMgr.class);
                actionDefinition = (ActionDefinition)constructor.newInstance(actionDefDomElement, actionInputProvider);
                break;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if (actionDefinition == null) {
            actionDefinition = new ActionDefinition(actionDefDomElement, actionInputProvider);
        }
        return actionDefinition;
    }

    public static Class getActionDefinition(String actionId) {
        if (!pluginsLoaded) {
            ActionFactory.loadPlugins();
        }
        return pluginActions.get(actionId);
    }

    private static SAXReader createSafeSaxReader() {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            logger.error((Object)e);
        }
        return reader;
    }
}

