/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import java.util.ArrayList;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionControlStatement;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionLoop;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class ActionLoop
extends ActionControlStatement
implements IActionLoop {
    public ActionLoop(Element loopElement, IActionParameterMgr actionInputProvider) {
        super(loopElement, actionInputProvider);
    }

    @Override
    public void setLoopOn(String loopOn) {
        Attribute attr = this.controlElement.attribute("loop-on");
        if (loopOn == null) {
            if (attr != null) {
                attr.detach();
                ActionSequenceDocument.fireControlStatementChanged(this);
            }
        } else {
            loopOn = loopOn.trim();
            if (attr == null) {
                this.controlElement.addAttribute("loop-on", loopOn);
                attr = this.controlElement.attribute("loop-on");
                ActionSequenceDocument.fireControlStatementChanged(this);
            } else if (!loopOn.equals(attr.getValue())) {
                attr.setValue(loopOn);
                ActionSequenceDocument.fireControlStatementChanged(this);
            }
        }
    }

    @Override
    public String getLoopOn() {
        return this.controlElement.attributeValue("loop-on");
    }

    @Override
    protected IActionSequenceValidationError[] validateThis() {
        ArrayList<String> errors = new ArrayList<String>();
        String loopOn = this.getLoopOn();
        if (loopOn.trim().length() == 0) {
            errors.add("Missing loop variable.");
        } else {
            IActionInputVariable[] actionVariables = this.getDocument().getAvailInputVariables(this);
            boolean isValid = false;
            for (int i = 0; i < actionVariables.length && !isValid; ++i) {
                isValid = actionVariables[i].getVariableName().equals(loopOn);
            }
            if (!isValid) {
                errors.add("Loop references unknown variable.");
            }
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    @Override
    public Boolean getLoopUsingPeek() {
        return Boolean.parseBoolean(this.controlElement.attributeValue("peek-only"));
    }

    @Override
    public void setLoopUsingPeek(Boolean usePeek) {
        Attribute attr = this.controlElement.attribute("peek-only");
        if (usePeek == null) {
            if (attr != null) {
                attr.detach();
                ActionSequenceDocument.fireControlStatementChanged(this);
            }
        } else if (attr == null) {
            this.controlElement.addAttribute("peek-only", usePeek.toString());
            attr = this.controlElement.attribute("peek-only");
            ActionSequenceDocument.fireControlStatementChanged(this);
        } else if (!usePeek.toString().equals(attr.getValue())) {
            attr.setValue(usePeek.toString());
            ActionSequenceDocument.fireControlStatementChanged(this);
        }
    }
}

