/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hl7input.common;

import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.util.SegmentFinder;
import ca.uhn.hl7v2.util.Terser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.trans.steps.hl7input.common.HL7Value;
import org.pentaho.di.trans.steps.hl7input.common.NamesUtil;

public class HL7KettleParser {
    public static List<HL7Value> extractValues(Message message) throws Exception {
        Terser terser = new Terser(message);
        SegmentFinder finder = terser.getFinder();
        ArrayList<HL7Value> values = new ArrayList<HL7Value>();
        int childNr = 1;
        while (finder.hasNextChild()) {
            finder.nextChild();
            Structure[] structures = finder.getCurrentChildReps();
            for (int i = 0; i < structures.length; ++i) {
                Structure structure = structures[i];
                HL7KettleParser.parseStructure(values, message, terser, structure, Integer.toString(childNr));
            }
            ++childNr;
        }
        return values;
    }

    private static void parseStructure(List<HL7Value> values, Message message, Terser terser, Structure structure, String structureNumber) throws Exception {
        Map<String, List<String>> nameMap = NamesUtil.getInstance().getMap();
        if (structure instanceof Segment) {
            Segment segment = (Segment)structure;
            String[] names = segment.getNames();
            for (int n = 1; n <= segment.numFields(); ++n) {
                Type[] types = segment.getField(n);
                for (int t = 0; t < types.length; ++t) {
                    int nrComponents = Terser.numComponents((Type)types[t]);
                    for (int c = 1; c <= nrComponents; ++c) {
                        int nrSub = Terser.numSubComponents((Type)types[t], (int)c);
                        for (int sc = 1; sc <= nrSub; ++sc) {
                            String string = Terser.get((Segment)segment, (int)n, (int)t, (int)c, (int)sc);
                            String description = "?";
                            List<String> list = nameMap.get(types[t].getName());
                            if (list != null && c - 1 < list.size()) {
                                description = list.get(c - 1);
                            }
                            Group group = structure.getParent();
                            Message rootGroup = structure.getMessage();
                            String coordinates = n + "." + (t + 1) + "." + c + "." + sc;
                            HL7Value value = new HL7Value(message.getVersion(), rootGroup.getName(), group.getName(), structure.getName(), structureNumber, names[n - 1], coordinates, types[t].getName(), description, string);
                            values.add(value);
                        }
                    }
                }
            }
        } else if (structure instanceof Group) {
            Group group = (Group)structure;
            String[] names = group.getNames();
            for (int n = 1; n <= names.length; ++n) {
                String name = names[n - 1];
                Structure subStructure = group.get(name);
                HL7KettleParser.parseStructure(values, message, terser, subStructure, structureNumber + "." + n);
            }
        } else {
            throw new Exception("oops, not handled yet!");
        }
    }
}

