/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.terafastbulkloader;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.core.util.StringListPluginProperty;
import org.pentaho.di.core.util.Utils;

public class FastloadControlBuilder {
    public static final String DATAFILE_COLUMN_SEPERATOR = "|";
    public static final String RECORD_FORMAT_UNFORMATTED = "unformatted";
    public static final String RECORD_VARTEXT = "VARTEXT \"|\"";
    public static final String DEFAULT_ERROR_TABLE1 = "error1";
    public static final String DEFAULT_ERROR_TABLE2 = "error2";
    public static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    public static final String DEFAULT_NULL_VALUE = "?";
    private final StringBuilder builder = new StringBuilder();

    public FastloadControlBuilder newline() {
        this.builder.append(';');
        this.builder.append(SystemUtils.LINE_SEPARATOR);
        return this;
    }

    public FastloadControlBuilder logon(String connectionString) throws IllegalArgumentException {
        Assert.assertNotBlank((String)connectionString, (String)"Connection must not be blank");
        this.builder.append("LOGON ").append(connectionString);
        return this.newline();
    }

    public FastloadControlBuilder logon(String dbhost, String user, String password) throws IllegalArgumentException {
        Assert.assertNotBlank((String)dbhost, (String)"DB host must not be blank");
        Assert.assertNotBlank((String)user, (String)"User must not be blank");
        Assert.assertNotNull((Object)password, (String)"Password must not be null");
        this.builder.append("LOGON ");
        this.builder.append(dbhost);
        this.builder.append('/');
        this.builder.append(user);
        this.builder.append(',');
        this.builder.append(password);
        return this.newline();
    }

    public FastloadControlBuilder setRecordFormat(String format) throws IllegalArgumentException {
        Assert.assertNotBlank((String)format, (String)"Format must not be blank");
        return this.line("SET RECORD " + format);
    }

    public FastloadControlBuilder setSessions(int sessions) throws IllegalArgumentException {
        Assert.assertGreaterZero((Integer)sessions);
        return this.line("SESSIONS " + sessions);
    }

    public FastloadControlBuilder setErrorLimit(int errorLimit) throws IllegalArgumentException {
        Assert.assertGreaterZero((Integer)errorLimit);
        return this.line("ERRLIMIT " + errorLimit);
    }

    public FastloadControlBuilder define(RowMetaInterface targetTableFields, StringListPluginProperty tableFieldList, String dataFile) {
        Assert.assertNotNull((Object)targetTableFields, (String)"fields cannot be null");
        Assert.assertNotNull((Object)dataFile, (String)"dataFile cannot be null");
        this.builder.append("DEFINE ");
        for (int i = 0; i < targetTableFields.size(); ++i) {
            ValueMetaInterface value = targetTableFields.getValueMeta(i);
            int tableIndex = ((List)tableFieldList.getValue()).indexOf(value.getName());
            if (tableIndex < 0) continue;
            this.builder.append(value.getName());
            int length = 0;
            length = value.getType() == 3 ? DEFAULT_DATE_FORMAT.length() : value.getLength();
            this.builder.append("(VARCHAR(" + length + "), nullif = '" + String.format("%1$" + length + "s", DEFAULT_NULL_VALUE) + "'), ");
            this.builder.append(SystemUtils.LINE_SEPARATOR);
        }
        this.builder.append(" NEWLINECHAR(VARCHAR(" + SystemUtils.LINE_SEPARATOR.length() + "))");
        this.builder.append(" FILE=" + dataFile);
        return this.newline();
    }

    public FastloadControlBuilder insert(RowMetaInterface targetTableFields, StringListPluginProperty tableFieldList, String tableName) {
        Assert.assertNotNull((Object)targetTableFields, (String)"targetTableFields cannot be null.");
        Assert.assertNotNull((Object)tableName, (String)"TableName cannot be null.");
        this.builder.append("INSERT INTO " + tableName + "(");
        for (int i = 0; i < targetTableFields.size(); ++i) {
            int tableIndex = ((List)tableFieldList.getValue()).indexOf(targetTableFields.getValueMeta(i).getName());
            if (tableIndex < 0) continue;
            this.builder.append(":" + targetTableFields.getValueMeta(i).getName());
            if (targetTableFields.getValueMeta(i).getType() == 3) {
                this.builder.append("(DATE, FORMAT '");
                this.builder.append(DEFAULT_DATE_FORMAT);
                this.builder.append("')");
            }
            if (i >= tableFieldList.size() - 1) continue;
            this.builder.append(",");
        }
        this.builder.append(")");
        return this.newline();
    }

    public FastloadControlBuilder show() {
        return this.line("SHOW");
    }

    public FastloadControlBuilder endLoading() {
        return this.line("END LOADING");
    }

    public FastloadControlBuilder beginLoading(String schemaName, String table) throws IllegalArgumentException {
        Assert.assertNotBlank((String)table);
        this.builder.append("BEGIN LOADING ");
        this.builder.append(table);
        this.builder.append(" ERRORFILES ");
        if (!Utils.isEmpty((CharSequence)schemaName)) {
            this.builder.append(schemaName);
            this.builder.append(".");
            this.builder.append(DEFAULT_ERROR_TABLE1);
            this.builder.append(",");
            this.builder.append(schemaName);
            this.builder.append(".");
            this.builder.append(DEFAULT_ERROR_TABLE2);
        } else {
            this.builder.append(DEFAULT_ERROR_TABLE1);
            this.builder.append(",");
            this.builder.append(DEFAULT_ERROR_TABLE2);
        }
        return this.newline();
    }

    public FastloadControlBuilder line(String line) {
        if (StringUtils.isBlank((String)line)) {
            return this;
        }
        this.builder.append(line);
        return this.newline();
    }

    public FastloadControlBuilder logoff() {
        this.builder.append("LOGOFF");
        return this.newline();
    }

    public String toString() {
        return this.builder.toString();
    }
}

