/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.locator.api.impl;

import java.util.Collection;
import java.util.Optional;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.osgi.api.MetastoreLocatorOsgi;
import org.pentaho.di.core.service.PluginServiceLoader;
import org.pentaho.di.job.JobExecutionExtension;
import org.pentaho.di.trans.Trans;
import org.pentaho.metastore.locator.api.MetastoreLocator;

@ExtensionPoint(id="MetastoreLocatorMetaLoadExtensionPoint", extensionPointId="TransformationMetaLoaded", description="")
public class MetastoreLocatorExtensionPoint
implements ExtensionPointInterface {
    MetastoreLocatorOsgi metastoreLocatorOsgi;

    public MetastoreLocatorExtensionPoint() {
        try {
            Collection metastoreLocators = PluginServiceLoader.loadServices(MetastoreLocator.class);
            Optional metastoreLocatorOptional = metastoreLocators.stream().findFirst();
            if (!metastoreLocatorOptional.isPresent()) {
                throw new KettlePluginException("No metastore locator found");
            }
            this.metastoreLocatorOsgi = (MetastoreLocatorOsgi)metastoreLocatorOptional.get();
        }
        catch (KettlePluginException e) {
            LogChannel.GENERAL.logError("Error getting metastore locator", (Throwable)e);
        }
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        Object meta = object instanceof Trans ? ((Trans)object).getTransMeta() : (object instanceof JobExecutionExtension ? ((JobExecutionExtension)object).job.getJobMeta() : (AbstractMeta)object);
        if (meta.getMetastoreLocatorOsgi() == null) {
            meta.setMetastoreLocatorOsgi(this.metastoreLocatorOsgi);
        }
    }
}

