/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class IBVersionUtil {
    private static final String VAR_IB_RELEASE = "version_comment";
    private static final int VER_MAJOR = 3;
    private static final int VER_MINOR = 5;
    private static final String VER_START_MARKER = "IB_";
    private static final String VER_END_MARKER = "_";
    private final Connection connection;

    public IBVersionUtil(Connection connection) {
        this.connection = connection;
    }

    public boolean isSupportsLocalInfile() throws SQLException {
        String versionComment = this.queryVariable(VAR_IB_RELEASE);
        int verIdx = versionComment.indexOf(VER_START_MARKER);
        if (verIdx < 0 || verIdx + VER_START_MARKER.length() >= versionComment.length()) {
            throw new RuntimeException("Invalid version_comment '" + versionComment + "'");
        }
        int nextUnderscoreIdx = versionComment.indexOf(VER_END_MARKER, verIdx + VER_START_MARKER.length());
        if (nextUnderscoreIdx < 0) {
            throw new RuntimeException("Invalid version_comment '" + versionComment + "'");
        }
        String versionNumber = versionComment.substring(verIdx + 3, nextUnderscoreIdx);
        String[] sDigits = versionNumber.split("\\.");
        if (sDigits.length < 2) {
            throw new RuntimeException("Invalid version_comment '" + versionComment + "'");
        }
        int[] digits = new int[sDigits.length];
        for (int i = 0; i < sDigits.length; ++i) {
            digits[i] = Integer.parseInt(sDigits[i]);
        }
        return digits[0] > 3 || digits[0] == 3 && digits[1] >= 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String queryVariable(String variableName) throws SQLException {
        String SQL = "show variables like '" + variableName + "'";
        String val = null;
        ResultSet rs = null;
        Statement stmt = this.connection.createStatement();
        try {
            stmt.executeQuery(SQL);
            rs = stmt.getResultSet();
            int numRows = 0;
            if (rs.next()) {
                ++numRows;
                val = rs.getObject(2).toString();
            }
            if (numRows == 0) {
                throw new RuntimeException("Failed to retrieve variable '" + variableName + "'");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        return val;
    }
}

