/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

class DecimalType
extends AbstractColumnType {
    private static final BigDecimal TEN = new BigDecimal(10);
    private final BigDecimal maxValue;
    private final BigDecimal minValue;
    private final int precision;
    private BigDecimal data;
    private final BigDecimal multiplier;

    DecimalType(int precision, int scale) {
        this.precision = precision;
        this.multiplier = TEN.pow(scale);
        this.maxValue = TEN.pow(precision).subtract(BigDecimal.ONE);
        this.minValue = this.maxValue.negate();
        this.data = BigDecimal.ZERO;
    }

    public String getDataAsString() {
        return this.data.divide(this.multiplier).toString();
    }

    public void getData(ByteBuffer byteBuffer) {
        if (this.precision < 3) {
            byteBuffer.put(this.data.byteValue());
        } else if (this.precision < 5) {
            byteBuffer.putShort(this.data.shortValue());
        } else if (this.precision < 10) {
            byteBuffer.putInt(this.data.intValue());
        } else {
            byteBuffer.putLong(this.data.longValue());
        }
    }

    private void setData(BigDecimal data) {
        if (data.compareTo(this.maxValue) > 0 || data.compareTo(this.minValue) < 0) {
            throw new ValueConverterException("value too large for column");
        }
        this.data = data;
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        BigDecimal tData = this.precision < 3 ? new BigDecimal(byteBuffer.get()) : (this.precision < 5 ? new BigDecimal(byteBuffer.getShort()) : (this.precision < 10 ? new BigDecimal(byteBuffer.getInt()) : new BigDecimal(byteBuffer.getLong())));
        this.setData(tData);
    }

    public void setData(String string) {
        this.setData(new BigDecimal(string).multiply(this.multiplier));
    }

    public void setData(Object value, ValueConverter meta) {
        if (value == null) {
            this.setIsNull(true);
        } else {
            BigDecimal val = meta.getBigNumber(value);
            if (val == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                this.setData(val.multiply(this.multiplier));
            }
        }
    }

    protected void zeroOutData() {
        this.data = BigDecimal.ZERO;
    }

    public final boolean isNeedsEnclosures() {
        return false;
    }
}

