/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GenericValueConverter
implements ValueConverter {
    protected final DateFormat dateFormat_DATE = new SimpleDateFormat("yyyy-MM-dd");
    protected final DateFormat dateFormat_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public BigDecimal getBigNumber(Object object) throws ValueConverterException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Float) {
            return new BigDecimal(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return new BigDecimal((Double)object);
        }
        if (object instanceof Number) {
            return new BigDecimal(((Number)object).longValue());
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ValueConverterException("value \"" + object.toString() + "\" of type " + object.getClass().getName() + " is not convertible to BigDecimal");
    }

    public byte[] getBinary(Object object) throws ValueConverterException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new ValueConverterException("value \"" + object.toString() + "\" of type " + object.getClass().getName() + " is not convertible to byte[]");
    }

    public byte[] getBinaryString(Object object) throws ValueConverterException {
        return this.getBinary(object);
    }

    public Boolean getBoolean(Object object) throws ValueConverterException {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ValueConverterException("value \"" + object.toString() + "\" of type " + object.getClass().getName() + " is not convertible to Boolean");
    }

    public Date getDate(Object object) throws ValueConverterException {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        throw new ValueConverterException("value \"" + object.toString() + "\" of type " + object.getClass().getName() + " is not convertible to Date");
    }

    public Long getInteger(Object object) throws ValueConverterException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool != false ? 1L : 0L;
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.length() == 0) {
                return null;
            }
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ValueConverterException("value \"" + object.toString() + "\" of type " + object.getClass().getName() + " is not convertible to Long");
    }

    public Double getNumber(Object object) throws ValueConverterException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.length() == 0) {
                return null;
            }
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ValueConverterException("value \"" + object.toString() + "\" of type " + object.getClass().getName() + " is not convertible to Double");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Object object) throws ValueConverterException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Character) {
            return new String(new char[]{((Character)object).charValue()}, 0, 1);
        }
        if (object instanceof char[]) {
            char[] ca = (char[])object;
            return new String(ca, 0, ca.length);
        }
        if (object instanceof Number) {
            return String.valueOf(object);
        }
        if (object instanceof Date) {
            DateFormat dateFormat = this.dateFormat_DATETIME;
            synchronized (dateFormat) {
                return this.dateFormat_DATETIME.format((Date)object);
            }
        }
        throw new ValueConverterException("value \"" + object.toString() + "\" of type " + object.getClass().getName() + " is not convertible to String");
    }
}

