/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.xml;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.xml.Handler;
import org.drools.core.xml.SemanticModule;

public class DefaultSemanticModule
implements SemanticModule {
    public String uri;
    public Map<String, Handler> handlers;
    public Map<Class<?>, Handler> handlersByClass;

    public DefaultSemanticModule(String uri) {
        this.uri = uri;
        this.handlers = new HashMap<String, Handler>();
        this.handlersByClass = new HashMap();
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void addHandler(String name, Handler handler) {
        this.handlers.put(name, handler);
        if (handler != null && handler.generateNodeFor() != null) {
            this.handlersByClass.put(handler.generateNodeFor(), handler);
        }
    }

    @Override
    public Handler getHandler(String name) {
        return this.handlers.get(name);
    }

    @Override
    public Handler getHandlerByClass(Class<?> clazz) {
        while (clazz != null) {
            Handler handler = this.handlersByClass.get(clazz);
            if (handler != null) {
                return handler;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

