/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.drools.core.factmodel.traits.LatticeElement;

public class HierNode<T>
implements LatticeElement<T>,
Comparable<HierNode<T>>,
Externalizable {
    public T value;
    public BitSet bitMask = null;
    public List<HierNode<T>> parents = new ArrayList<HierNode<T>>();
    public List<HierNode<T>> children = new ArrayList<HierNode<T>>();

    public HierNode() {
    }

    public HierNode(T value) {
        this.value = value;
    }

    protected HierNode(HierNode<T> xt) {
        this.value = xt.getValue();
        this.bitMask = xt.getBitMask();
        this.parents.addAll(xt.getParents());
        this.children.addAll(xt.getChildren());
    }

    public HierNode(BitSet key) {
        this.bitMask = key;
    }

    public HierNode(T val, BitSet key) {
        this.value = val;
        this.bitMask = key;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public BitSet getBitMask() {
        return this.bitMask;
    }

    public void setBitMask(BitSet bitMask) {
        if (this.bitMask == null) {
            this.bitMask = bitMask;
        } else {
            this.bitMask.clear();
            this.bitMask.or(bitMask);
        }
    }

    public Collection<HierNode<T>> getParents() {
        return this.parents;
    }

    public Collection<HierNode<T>> getChildren() {
        return this.children;
    }

    public void addChild(HierNode<T> node) {
        this.children.add(node);
    }

    public void addParent(HierNode<T> node) {
        this.parents.add(node);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierNode hierNode = (HierNode)o;
        return this.bitMask.equals(hierNode.bitMask);
    }

    public int hashCode() {
        return this.bitMask.hashCode();
    }

    public String toString() {
        return this.toString(this.bitMask != null ? this.bitMask.length() : 0);
    }

    public String toString(int len) {
        return this.value + "[ " + (this.bitMask != null ? this.toBinaryString(this.bitMask, len) : "n/a") + "]";
    }

    protected String toBinaryString(BitSet mask, int len) {
        StringBuilder sb = new StringBuilder();
        for (int j = len - 1; j >= 0; --j) {
            sb.append(mask.get(j) ? "1 " : "0 ");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(HierNode<T> hierNode) {
        int l;
        BitSet yset = hierNode.bitMask;
        for (int j = l = (lx = this.bitMask.length()) > (ly = yset.length()) ? lx : ly; j >= 0; --j) {
            boolean x = this.bitMask.get(j);
            boolean y = yset.get(j);
            if (x && !y) {
                return 1;
            }
            if (!y || x) continue;
            return -1;
        }
        return 0;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.value);
        out.writeObject(this.bitMask);
        out.writeObject(this.parents);
        out.writeObject(this.children);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
        this.bitMask = (BitSet)in.readObject();
        this.parents = (List)in.readObject();
        this.children = (List)in.readObject();
    }
}

