/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import org.drools.core.base.FieldDataFactory;
import org.drools.core.base.ValueType;
import org.drools.core.base.field.BooleanFieldImpl;
import org.drools.core.base.field.ClassFieldImpl;
import org.drools.core.base.field.DoubleFieldImpl;
import org.drools.core.base.field.LongFieldImpl;
import org.drools.core.base.field.ObjectFieldImpl;
import org.drools.core.spi.FieldValue;
import org.drools.core.util.DateUtils;
import org.drools.core.util.MathUtils;

public class FieldFactory
implements FieldDataFactory,
Serializable {
    private static final FieldFactory INSTANCE = new FieldFactory();

    public static FieldFactory getInstance() {
        return INSTANCE;
    }

    protected FieldFactory() {
    }

    @Override
    public FieldValue getFieldValue(String value, ValueType valueType) {
        FieldValue field = null;
        if (value == null || "null".equals(value)) {
            valueType = ValueType.NULL_TYPE;
        }
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if (valueType == ValueType.NULL_TYPE) {
            field = new ObjectFieldImpl(null);
        } else if (valueType == ValueType.PCHAR_TYPE) {
            field = new LongFieldImpl(value.charAt(0));
        } else if (valueType == ValueType.PBYTE_TYPE) {
            field = new LongFieldImpl(Long.parseLong(value));
        } else if (valueType == ValueType.PSHORT_TYPE) {
            field = new LongFieldImpl(Long.parseLong(value));
        } else if (valueType == ValueType.PINTEGER_TYPE) {
            field = new LongFieldImpl(Long.parseLong(this.stripNumericType(value)));
        } else if (valueType == ValueType.PLONG_TYPE) {
            field = new LongFieldImpl(Long.parseLong(this.stripNumericType(value)));
        } else if (valueType == ValueType.PFLOAT_TYPE) {
            field = new DoubleFieldImpl(Float.parseFloat(this.stripNumericType(value)));
        } else if (valueType == ValueType.PDOUBLE_TYPE) {
            field = new DoubleFieldImpl(Double.parseDouble(this.stripNumericType(value)));
        } else if (valueType == ValueType.PBOOLEAN_TYPE) {
            field = new BooleanFieldImpl(Boolean.valueOf(value));
        } else if (valueType == ValueType.CHAR_TYPE) {
            field = new ObjectFieldImpl(Character.valueOf(value.charAt(0)));
        } else if (valueType == ValueType.BYTE_TYPE) {
            field = new ObjectFieldImpl(new Byte(value));
        } else if (valueType == ValueType.SHORT_TYPE) {
            field = new ObjectFieldImpl(new Short(value));
        } else if (valueType == ValueType.INTEGER_TYPE) {
            field = new ObjectFieldImpl(new Integer(this.stripNumericType(value)));
        } else if (valueType == ValueType.LONG_TYPE) {
            field = new ObjectFieldImpl(new Long(this.stripNumericType(value)));
        } else if (valueType == ValueType.FLOAT_TYPE) {
            field = new ObjectFieldImpl(new Float(this.stripNumericType(value)));
        } else if (valueType == ValueType.DOUBLE_TYPE) {
            field = new ObjectFieldImpl(new Double(this.stripNumericType(value)));
        } else if (valueType == ValueType.BOOLEAN_TYPE) {
            field = new ObjectFieldImpl(Boolean.valueOf(value));
        } else if (valueType == ValueType.STRING_TYPE) {
            field = new ObjectFieldImpl(value.intern());
        } else if (valueType == ValueType.DATE_TYPE) {
            Date date = DateUtils.parseDate(value);
            field = new ObjectFieldImpl(date);
        } else if (valueType == ValueType.ARRAY_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.OBJECT_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.BIG_DECIMAL_TYPE) {
            field = new ObjectFieldImpl(MathUtils.getBigDecimal(value));
        } else if (valueType == ValueType.BIG_INTEGER_TYPE) {
            field = new ObjectFieldImpl(MathUtils.getBigInteger(value));
        } else if (valueType == ValueType.CLASS_TYPE) {
            field = new ClassFieldImpl(value);
        }
        return field;
    }

    @Override
    public FieldValue getFieldValue(Object value, ValueType valueType) {
        FieldValue field = null;
        if (value == null) {
            valueType = ValueType.NULL_TYPE;
        }
        if (valueType == ValueType.NULL_TYPE) {
            field = new ObjectFieldImpl(null);
        } else if (valueType == ValueType.PCHAR_TYPE || valueType == ValueType.CHAR_TYPE) {
            field = value instanceof String && ((String)value).length() == 1 ? new LongFieldImpl(((String)value).charAt(0)) : new LongFieldImpl(((Character)value).charValue());
        } else if (valueType == ValueType.PBYTE_TYPE || valueType == ValueType.BYTE_TYPE) {
            field = value instanceof String ? new LongFieldImpl(Byte.parseByte((String)value)) : new LongFieldImpl(((Number)value).byteValue());
        } else if (valueType == ValueType.PSHORT_TYPE || valueType == ValueType.SHORT_TYPE) {
            if (value instanceof String) {
                try {
                    field = new LongFieldImpl(NumberFormat.getInstance().parse((String)value).shortValue());
                }
                catch (ParseException e) {
                    throw new NumberFormatException("Error parsing number '" + value + "'");
                }
            } else {
                field = new LongFieldImpl(((Number)value).shortValue());
            }
        } else if (valueType == ValueType.PINTEGER_TYPE || valueType == ValueType.INTEGER_TYPE) {
            if (value instanceof String) {
                try {
                    field = new LongFieldImpl(NumberFormat.getInstance().parse((String)value).intValue());
                }
                catch (ParseException e) {
                    throw new NumberFormatException("Error parsing number '" + value + "'");
                }
            } else {
                field = new LongFieldImpl(((Number)value).intValue());
            }
        } else if (valueType == ValueType.PLONG_TYPE || valueType == ValueType.LONG_TYPE) {
            if (value instanceof String) {
                try {
                    field = new LongFieldImpl(NumberFormat.getInstance().parse((String)value).longValue());
                }
                catch (ParseException e) {
                    throw new NumberFormatException("Error parsing number '" + value + "'");
                }
            } else {
                field = new LongFieldImpl(((Number)value).longValue());
            }
        } else if (valueType == ValueType.PFLOAT_TYPE || valueType == ValueType.FLOAT_TYPE) {
            if (value instanceof String) {
                try {
                    field = new DoubleFieldImpl(NumberFormat.getInstance().parse((String)value).floatValue());
                }
                catch (ParseException e) {
                    throw new NumberFormatException("Error parsing number '" + value + "'");
                }
            } else {
                field = new DoubleFieldImpl(((Number)value).floatValue());
            }
        } else if (valueType == ValueType.PDOUBLE_TYPE || valueType == ValueType.DOUBLE_TYPE) {
            if (value instanceof String) {
                try {
                    field = new DoubleFieldImpl(NumberFormat.getInstance().parse((String)value).doubleValue());
                }
                catch (ParseException e) {
                    throw new NumberFormatException("Error parsing number '" + value + "'");
                }
            } else {
                field = new DoubleFieldImpl(((Number)value).doubleValue());
            }
        } else if (valueType == ValueType.PBOOLEAN_TYPE || valueType == ValueType.BOOLEAN_TYPE) {
            field = value instanceof String ? new BooleanFieldImpl(Boolean.valueOf((String)value)) : new BooleanFieldImpl((Boolean)value);
        } else if (valueType == ValueType.STRING_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.DATE_TYPE) {
            if (value instanceof String) {
                Date date = DateUtils.parseDate((String)value);
                field = new ObjectFieldImpl(date);
            } else {
                field = new ObjectFieldImpl(value);
            }
        } else if (valueType == ValueType.ARRAY_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.OBJECT_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.TRAIT_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.BIG_DECIMAL_TYPE) {
            field = new ObjectFieldImpl(MathUtils.getBigDecimal(value));
        } else if (valueType == ValueType.BIG_INTEGER_TYPE) {
            field = new ObjectFieldImpl(MathUtils.getBigInteger(value));
        } else if (valueType == ValueType.CLASS_TYPE) {
            field = new ClassFieldImpl((Class)value);
        }
        return field;
    }

    @Override
    public FieldValue getFieldValue(Object value) {
        return new ObjectFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(byte value) {
        return new LongFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(short value) {
        return new LongFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(char value) {
        return new LongFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(int value) {
        return new LongFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(long value) {
        return new LongFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(boolean value) {
        return new BooleanFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(float value) {
        return new DoubleFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(double value) {
        return new DoubleFieldImpl(value);
    }

    @Override
    public FieldValue getFieldValue(Class value) {
        return value == null ? new ObjectFieldImpl(null) : new ClassFieldImpl(value);
    }

    private String stripNumericType(String value) {
        if (Character.getType(value.charAt(value.length() - 1)) != 9) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

