/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.googleanalytics;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.analytics.Analytics;
import com.google.api.services.analytics.model.GaData;
import com.google.api.services.analytics.model.Profile;
import com.google.api.services.analytics.model.Profiles;
import com.google.api.services.analytics.model.Segment;
import com.google.api.services.analytics.model.Segments;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStepMeta;
import org.pentaho.di.trans.steps.googleanalytics.GoogleAnalyticsApiFacade;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.events.dialog.FilterType;
import org.pentaho.di.ui.core.events.dialog.ProviderFilterType;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterFileDialogTextVar;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterOptions;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.googleanalytics.BareBonesBrowserLaunch;

public class GaInputStepDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = GaInputStepMeta.class;
    private GaInputStepMeta input;
    private HashMap<String, String> profileTableIds = new HashMap();
    private HashMap<String, String> segmentIds = new HashMap();
    private Label wlOauthAccount;
    private TextVar wOauthAccount;
    private Button fileChooser;
    private TextVar keyFilename;
    private Link wlFields;
    private TableView wFields;
    private CCombo wGaProfile;
    private Label wlGaProfile;
    private Button wGetProfiles;
    private Label wlQuSegment;
    private CCombo wQuSegment;
    private Button wGetSegments;
    private Label wlQuStartDate;
    private TextVar wQuStartDate;
    private Label wlQuEndDate;
    private TextVar wQuEndDate;
    private Label wlQuDimensions;
    private TextVar wQuDimensions;
    private Label wlQuMetrics;
    private TextVar wQuMetrics;
    private Label wlQuFilters;
    private TextVar wQuFilters;
    private Label wlQuSort;
    private TextVar wQuSort;
    private Link wQuSortReference;
    private Link wQuFiltersReference;
    private Link wQuMetricsReference;
    private Link wQuDimensionsReference;
    private Link wQuSamplingLevelReference;
    private Label wlQuCustomSegment;
    private TextVar wQuCustomSegment;
    private Link wQuCustomSegmentReference;
    private Button wCustomSegmentEnabled;
    private Label wlGaCustomProfile;
    private Button wCustomProfileEnabled;
    private TextVar wGaCustomProfile;
    private Link wGaCustomProfileReference;
    private Group gConnect;
    private Label wlGaAppName;
    private TextVar wGaAppName;
    private Label wlLimit;
    private Text wLimit;
    private Label wlQuUseSegment;
    private Button wUseSegmentEnabled;
    private Label wlQuSamplingLevel;
    private CCombo wQuSamplingLevel;
    private int middle;
    private int margin;
    private ModifyListener lsMod;
    static final String REFERENCE_SORT_URI = "https://developers.google.com/analytics/devguides/reporting/core/v3/reference#sort";
    static final String REFERENCE_METRICS_URI = "https://developers.google.com/analytics/devguides/reporting/core/v3/reference#metrics";
    static final String REFERENCE_DIMENSIONS_URI = "https://developers.google.com/analytics/devguides/reporting/core/v3/reference#dimensions";
    static final String REFERENCE_SEGMENT_URI = "https://developers.google.com/analytics/devguides/reporting/core/v3/reference#segment";
    static final String REFERENCE_FILTERS_URI = "https://developers.google.com/analytics/devguides/reporting/core/v3/reference#filters";
    static final String REFERENCE_DIMENSION_AND_METRIC_URI = "https://developers.google.com/analytics/devguides/reporting/core/v3/";
    static final String REFERENCE_TABLE_ID_URI = "https://developers.google.com/analytics/devguides/reporting/core/v3/reference#ids";
    static final String REFERENCE_SAMPLING_LEVEL_URI = "https://developers.google.com/analytics/devguides/reporting/core/v3/reference#samplingLevel";

    public GaInputStepDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.setInput((GaInputStepMeta)((Object)in));
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.getInput());
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GaInputStepDialog.this.getInput().setChanged();
            }
        };
        this.backupChanged = this.getInput().hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(this.middle, -this.margin);
        this.fdlStepname.top = new FormAttachment(0, this.margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(this.middle, 0);
        this.fdStepname.top = new FormAttachment(0, this.margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.gConnect = new Group((Composite)this.shell, 16);
        this.gConnect.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ConnectGroup.Label", (String[])new String[0]));
        FormLayout gConnectLayout = new FormLayout();
        gConnectLayout.marginWidth = 3;
        gConnectLayout.marginHeight = 3;
        this.gConnect.setLayout((Layout)gConnectLayout);
        this.props.setLook((Control)this.gConnect);
        FormData fdConnect = new FormData();
        fdConnect.left = new FormAttachment(0, 0);
        fdConnect.right = new FormAttachment(100, 0);
        fdConnect.top = new FormAttachment((Control)this.wStepname, this.margin);
        this.gConnect.setLayoutData((Object)fdConnect);
        this.wlGaAppName = new Label((Composite)this.gConnect, 131072);
        this.wlGaAppName.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AppName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGaAppName);
        FormData fdlGaAppName = new FormData();
        fdlGaAppName.top = new FormAttachment(0, this.margin);
        fdlGaAppName.left = new FormAttachment(0, 0);
        fdlGaAppName.right = new FormAttachment(this.middle, -this.margin);
        this.wlGaAppName.setLayoutData((Object)fdlGaAppName);
        this.wGaAppName = new TextVar((VariableSpace)this.transMeta, (Composite)this.gConnect, 18436);
        this.wGaAppName.addModifyListener(this.lsMod);
        this.wGaAppName.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AppName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wGaAppName);
        FormData fdGaAppName = new FormData();
        fdGaAppName.top = new FormAttachment((Control)this.wStepname, this.margin);
        fdGaAppName.left = new FormAttachment(this.middle, 0);
        fdGaAppName.right = new FormAttachment(100, 0);
        this.wGaAppName.setLayoutData((Object)fdGaAppName);
        this.createOauthServiceCredentialsControls();
        this.wlGaCustomProfile = new Label((Composite)this.gConnect, 131072);
        this.wlGaCustomProfile.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Profile.CustomProfileEnabled.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGaCustomProfile);
        FormData fdlGaCustomProfile = new FormData();
        fdlGaCustomProfile.top = new FormAttachment((Control)this.keyFilename, this.margin);
        fdlGaCustomProfile.left = new FormAttachment(0, 0);
        fdlGaCustomProfile.right = new FormAttachment(this.middle, -this.margin);
        this.wlGaCustomProfile.setLayoutData((Object)fdlGaCustomProfile);
        this.wCustomProfileEnabled = new Button((Composite)this.gConnect, 32);
        this.wCustomProfileEnabled.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Profile.CustomProfileEnabled.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCustomProfileEnabled);
        this.wCustomProfileEnabled.pack(true);
        FormData fdCustomProfileEnabled = new FormData();
        fdCustomProfileEnabled.left = new FormAttachment(this.middle, 0);
        fdCustomProfileEnabled.top = new FormAttachment((Control)this.keyFilename, this.margin);
        this.wCustomProfileEnabled.setLayoutData((Object)fdCustomProfileEnabled);
        this.wCustomProfileEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GaInputStepDialog.this.getInput().setChanged();
                GaInputStepDialog.this.setActive();
                if (GaInputStepDialog.this.wCustomProfileEnabled.getSelection()) {
                    GaInputStepDialog.this.wGaCustomProfile.setFocus();
                } else {
                    GaInputStepDialog.this.wGaProfile.setFocus();
                }
            }
        });
        this.wGaCustomProfile = new TextVar((VariableSpace)this.transMeta, (Composite)this.gConnect, 18436);
        this.wGaCustomProfile.addModifyListener(this.lsMod);
        this.wGaCustomProfile.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Profile.CustomProfile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wGaCustomProfile);
        this.wGaCustomProfileReference = new Link((Composite)this.gConnect, 4);
        this.wGaCustomProfileReference.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Reference.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wGaCustomProfileReference);
        this.wGaCustomProfileReference.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                BareBonesBrowserLaunch.openURL(GaInputStepDialog.REFERENCE_TABLE_ID_URI);
            }
        });
        this.wGaCustomProfileReference.pack(true);
        FormData fdGaCustomProfile = new FormData();
        fdGaCustomProfile.top = new FormAttachment((Control)this.keyFilename, this.margin);
        fdGaCustomProfile.left = new FormAttachment((Control)this.wCustomProfileEnabled, this.margin);
        fdGaCustomProfile.right = new FormAttachment(100, -this.wGaCustomProfileReference.getBounds().width - this.margin);
        this.wGaCustomProfile.setLayoutData((Object)fdGaCustomProfile);
        FormData fdGaCustomProfileReference = new FormData();
        fdGaCustomProfileReference.top = new FormAttachment((Control)this.keyFilename, this.margin);
        fdGaCustomProfileReference.left = new FormAttachment((Control)this.wGaCustomProfile, 0);
        fdGaCustomProfileReference.right = new FormAttachment(100, 0);
        this.wGaCustomProfileReference.setLayoutData((Object)fdGaCustomProfileReference);
        this.wlGaProfile = new Label((Composite)this.gConnect, 131072);
        this.wlGaProfile.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Profile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGaProfile);
        FormData fdlGaProfile = new FormData();
        fdlGaProfile.top = new FormAttachment((Control)this.wGaCustomProfile, this.margin);
        fdlGaProfile.left = new FormAttachment(0, 0);
        fdlGaProfile.right = new FormAttachment(this.middle, -this.margin);
        this.wlGaProfile.setLayoutData((Object)fdlGaProfile);
        this.wGaProfile = new CCombo((Composite)this.gConnect, 18444);
        this.props.setLook((Control)this.wGaProfile);
        this.wGaProfile.addModifyListener(this.lsMod);
        this.wGaProfile.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Profile.Tooltip", (String[])new String[0]));
        this.wGetProfiles = new Button((Composite)this.gConnect, 8);
        this.wGetProfiles.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Profile.GetProfilesButton.Label", (String[])new String[0]));
        this.wGetProfiles.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Profile.GetProfilesButton.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wGetProfiles);
        this.wGetProfiles.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                GaInputStepDialog.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GaInputStepDialog.this.readGaProfiles();
                    }
                });
            }
        });
        this.wGetProfiles.pack(true);
        FormData fdGaProfile = new FormData();
        fdGaProfile.left = new FormAttachment(this.middle, 0);
        fdGaProfile.top = new FormAttachment((Control)this.wGaCustomProfile, this.margin);
        fdGaProfile.right = new FormAttachment(100, -this.wGetProfiles.getBounds().width - this.margin);
        this.wGaProfile.setLayoutData((Object)fdGaProfile);
        FormData fdGetProfiles = new FormData();
        fdGetProfiles.left = new FormAttachment((Control)this.wGaProfile, 0);
        fdGetProfiles.top = new FormAttachment((Control)this.wGaCustomProfile, this.margin);
        fdGetProfiles.right = new FormAttachment(100, 0);
        this.wGetProfiles.setLayoutData((Object)fdGetProfiles);
        Group gQuery = new Group((Composite)this.shell, 16);
        gQuery.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.QueryGroup.Label", (String[])new String[0]));
        FormLayout gQueryLayout = new FormLayout();
        gQueryLayout.marginWidth = 3;
        gQueryLayout.marginHeight = 3;
        gQuery.setLayout((Layout)gQueryLayout);
        this.props.setLook((Control)gQuery);
        this.wlQuStartDate = new Label((Composite)gQuery, 131072);
        this.wlQuStartDate.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.StartDate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuStartDate);
        FormData fdlQuStartDate = new FormData();
        fdlQuStartDate.top = new FormAttachment(0, this.margin);
        fdlQuStartDate.left = new FormAttachment(0, 0);
        fdlQuStartDate.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuStartDate.setLayoutData((Object)fdlQuStartDate);
        this.wQuStartDate = new TextVar((VariableSpace)this.transMeta, (Composite)gQuery, 18436);
        this.wQuStartDate.addModifyListener(this.lsMod);
        this.wQuStartDate.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.StartDate.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wQuStartDate);
        FormData fdQuStartDate = new FormData();
        fdQuStartDate.top = new FormAttachment(0, this.margin);
        fdQuStartDate.left = new FormAttachment(this.middle, 0);
        fdQuStartDate.right = new FormAttachment(100, 0);
        this.wQuStartDate.setLayoutData((Object)fdQuStartDate);
        this.wlQuEndDate = new Label((Composite)gQuery, 131072);
        this.wlQuEndDate.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.EndDate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuEndDate);
        FormData fdlQuEndDate = new FormData();
        fdlQuEndDate.top = new FormAttachment((Control)this.wQuStartDate, this.margin);
        fdlQuEndDate.left = new FormAttachment(0, 0);
        fdlQuEndDate.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuEndDate.setLayoutData((Object)fdlQuEndDate);
        this.wQuEndDate = new TextVar((VariableSpace)this.transMeta, (Composite)gQuery, 18436);
        this.wQuEndDate.addModifyListener(this.lsMod);
        this.wQuEndDate.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.EndDate.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wQuEndDate);
        FormData fdQuEndDate = new FormData();
        fdQuEndDate.top = new FormAttachment((Control)this.wQuStartDate, this.margin);
        fdQuEndDate.left = new FormAttachment(this.middle, 0);
        fdQuEndDate.right = new FormAttachment(100, 0);
        this.wQuEndDate.setLayoutData((Object)fdQuEndDate);
        this.wlQuDimensions = new Label((Composite)gQuery, 131072);
        this.wlQuDimensions.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Dimensions.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuDimensions);
        FormData fdlQuDimensions = new FormData();
        fdlQuDimensions.top = new FormAttachment((Control)this.wQuEndDate, this.margin);
        fdlQuDimensions.left = new FormAttachment(0, 0);
        fdlQuDimensions.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuDimensions.setLayoutData((Object)fdlQuDimensions);
        this.wQuDimensions = new TextVar((VariableSpace)this.transMeta, (Composite)gQuery, 18436);
        this.wQuDimensions.addModifyListener(this.lsMod);
        this.wQuDimensions.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Dimensions.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wQuDimensions);
        this.wQuDimensionsReference = new Link((Composite)gQuery, 4);
        this.wQuDimensionsReference.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Reference.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wQuDimensionsReference);
        this.wQuDimensionsReference.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                BareBonesBrowserLaunch.openURL(GaInputStepDialog.REFERENCE_DIMENSIONS_URI);
            }
        });
        this.wQuDimensionsReference.pack(true);
        FormData fdQuDimensions = new FormData();
        fdQuDimensions.top = new FormAttachment((Control)this.wQuEndDate, this.margin);
        fdQuDimensions.left = new FormAttachment(this.middle, 0);
        fdQuDimensions.right = new FormAttachment(100, -this.wQuDimensionsReference.getBounds().width - this.margin);
        this.wQuDimensions.setLayoutData((Object)fdQuDimensions);
        FormData fdQuDimensionsReference = new FormData();
        fdQuDimensionsReference.top = new FormAttachment((Control)this.wQuEndDate, this.margin);
        fdQuDimensionsReference.left = new FormAttachment((Control)this.wQuDimensions, 0);
        fdQuDimensionsReference.right = new FormAttachment(100, 0);
        this.wQuDimensionsReference.setLayoutData((Object)fdQuDimensionsReference);
        this.wlQuMetrics = new Label((Composite)gQuery, 131072);
        this.wlQuMetrics.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Metrics.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuMetrics);
        FormData fdlQuMetrics = new FormData();
        fdlQuMetrics.top = new FormAttachment((Control)this.wQuDimensions, this.margin);
        fdlQuMetrics.left = new FormAttachment(0, 0);
        fdlQuMetrics.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuMetrics.setLayoutData((Object)fdlQuMetrics);
        this.wQuMetrics = new TextVar((VariableSpace)this.transMeta, (Composite)gQuery, 18436);
        this.wQuMetrics.addModifyListener(this.lsMod);
        this.wQuMetrics.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Metrics.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wQuMetrics);
        this.wQuMetricsReference = new Link((Composite)gQuery, 4);
        this.wQuMetricsReference.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Reference.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wQuMetricsReference);
        this.wQuMetricsReference.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                BareBonesBrowserLaunch.openURL(GaInputStepDialog.REFERENCE_METRICS_URI);
            }
        });
        this.wQuMetricsReference.pack(true);
        FormData fdQuMetrics = new FormData();
        fdQuMetrics.top = new FormAttachment((Control)this.wQuDimensions, this.margin);
        fdQuMetrics.left = new FormAttachment(this.middle, 0);
        fdQuMetrics.right = new FormAttachment(100, -this.wQuMetricsReference.getBounds().width - this.margin);
        this.wQuMetrics.setLayoutData((Object)fdQuMetrics);
        FormData fdQuMetricsReference = new FormData();
        fdQuMetricsReference.top = new FormAttachment((Control)this.wQuDimensions, this.margin);
        fdQuMetricsReference.left = new FormAttachment((Control)this.wQuMetrics, 0);
        fdQuMetricsReference.right = new FormAttachment(100, 0);
        this.wQuMetricsReference.setLayoutData((Object)fdQuMetricsReference);
        this.wlQuFilters = new Label((Composite)gQuery, 131072);
        this.wlQuFilters.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Filters.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuFilters);
        FormData fdlQuFilters = new FormData();
        fdlQuFilters.top = new FormAttachment((Control)this.wQuMetrics, this.margin);
        fdlQuFilters.left = new FormAttachment(0, 0);
        fdlQuFilters.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuFilters.setLayoutData((Object)fdlQuFilters);
        this.wQuFilters = new TextVar((VariableSpace)this.transMeta, (Composite)gQuery, 18436);
        this.wQuFilters.addModifyListener(this.lsMod);
        this.wQuFilters.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Filters.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wQuFilters);
        this.wQuFiltersReference = new Link((Composite)gQuery, 4);
        this.wQuFiltersReference.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Reference.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wQuFiltersReference);
        this.wQuFiltersReference.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                BareBonesBrowserLaunch.openURL(GaInputStepDialog.REFERENCE_FILTERS_URI);
            }
        });
        this.wQuFiltersReference.pack(true);
        FormData fdQuFilters = new FormData();
        fdQuFilters.top = new FormAttachment((Control)this.wQuMetrics, this.margin);
        fdQuFilters.left = new FormAttachment(this.middle, 0);
        fdQuFilters.right = new FormAttachment(100, -this.wQuFiltersReference.getBounds().width - this.margin);
        this.wQuFilters.setLayoutData((Object)fdQuFilters);
        FormData fdQuFiltersReference = new FormData();
        fdQuFiltersReference.top = new FormAttachment((Control)this.wQuMetrics, this.margin);
        fdQuFiltersReference.left = new FormAttachment((Control)this.wQuFilters, 0);
        fdQuFiltersReference.right = new FormAttachment(100, 0);
        this.wQuFiltersReference.setLayoutData((Object)fdQuFiltersReference);
        this.wlQuSort = new Label((Composite)gQuery, 131072);
        this.wlQuSort.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Sort.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuSort);
        FormData fdlQuSort = new FormData();
        fdlQuSort.top = new FormAttachment((Control)this.wQuFilters, this.margin);
        fdlQuSort.left = new FormAttachment(0, 0);
        fdlQuSort.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuSort.setLayoutData((Object)fdlQuSort);
        this.wQuSort = new TextVar((VariableSpace)this.transMeta, (Composite)gQuery, 18436);
        this.wQuSort.addModifyListener(this.lsMod);
        this.wQuSort.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Sort.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wQuSort);
        this.wQuSortReference = new Link((Composite)gQuery, 4);
        this.wQuSortReference.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Reference.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wQuSortReference);
        this.wQuSortReference.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                BareBonesBrowserLaunch.openURL(GaInputStepDialog.REFERENCE_SORT_URI);
            }
        });
        this.wQuSortReference.pack(true);
        FormData fdQuSort = new FormData();
        fdQuSort.top = new FormAttachment((Control)this.wQuFilters, this.margin);
        fdQuSort.left = new FormAttachment(this.middle, 0);
        fdQuSort.right = new FormAttachment(100, -this.wQuSortReference.getBounds().width - this.margin);
        this.wQuSort.setLayoutData((Object)fdQuSort);
        FormData fdQuSortReference = new FormData();
        fdQuSortReference.top = new FormAttachment((Control)this.wQuFilters, this.margin);
        fdQuSortReference.left = new FormAttachment((Control)this.wQuSort, 0);
        fdQuSortReference.right = new FormAttachment(100, 0);
        this.wQuSortReference.setLayoutData((Object)fdQuSortReference);
        this.wlQuUseSegment = new Label((Composite)gQuery, 131072);
        this.wlQuUseSegment.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.UseSegment.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuUseSegment);
        FormData fdlQuUseSegment = new FormData();
        fdlQuUseSegment.top = new FormAttachment((Control)this.wQuSort, this.margin);
        fdlQuUseSegment.left = new FormAttachment(0, 0);
        fdlQuUseSegment.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuUseSegment.setLayoutData((Object)fdlQuUseSegment);
        this.wUseSegmentEnabled = new Button((Composite)gQuery, 32);
        this.props.setLook((Control)this.wUseSegmentEnabled);
        this.wUseSegmentEnabled.pack(true);
        FormData fdUseSegmentEnabled = new FormData();
        fdUseSegmentEnabled.left = new FormAttachment(this.middle, 0);
        fdUseSegmentEnabled.top = new FormAttachment((Control)this.wQuSort, this.margin);
        this.wUseSegmentEnabled.setLayoutData((Object)fdUseSegmentEnabled);
        this.wUseSegmentEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GaInputStepDialog.this.getInput().setChanged();
                GaInputStepDialog.this.setActive();
                if (GaInputStepDialog.this.wUseSegmentEnabled.getSelection()) {
                    if (GaInputStepDialog.this.wCustomSegmentEnabled.getSelection()) {
                        GaInputStepDialog.this.wQuCustomSegment.setFocus();
                    } else {
                        GaInputStepDialog.this.wQuSegment.setFocus();
                    }
                }
            }
        });
        this.wlQuCustomSegment = new Label((Composite)gQuery, 131072);
        this.wlQuCustomSegment.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.CustomSegment.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuCustomSegment);
        FormData fdlQuCustomSegment = new FormData();
        fdlQuCustomSegment.top = new FormAttachment((Control)this.wUseSegmentEnabled, this.margin);
        fdlQuCustomSegment.left = new FormAttachment(0, 0);
        fdlQuCustomSegment.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuCustomSegment.setLayoutData((Object)fdlQuCustomSegment);
        this.wCustomSegmentEnabled = new Button((Composite)gQuery, 32);
        this.props.setLook((Control)this.wCustomSegmentEnabled);
        this.wCustomSegmentEnabled.pack(true);
        FormData fdCustomSegmentEnabled = new FormData();
        fdCustomSegmentEnabled.left = new FormAttachment(this.middle, 0);
        fdCustomSegmentEnabled.top = new FormAttachment((Control)this.wUseSegmentEnabled, this.margin);
        this.wCustomSegmentEnabled.setLayoutData((Object)fdCustomSegmentEnabled);
        this.wCustomSegmentEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GaInputStepDialog.this.getInput().setChanged();
                GaInputStepDialog.this.setActive();
                if (GaInputStepDialog.this.wCustomSegmentEnabled.getSelection()) {
                    GaInputStepDialog.this.wQuCustomSegment.setFocus();
                } else {
                    GaInputStepDialog.this.wQuSegment.setFocus();
                }
            }
        });
        this.wQuCustomSegment = new TextVar((VariableSpace)this.transMeta, (Composite)gQuery, 18436);
        this.wQuCustomSegment.addModifyListener(this.lsMod);
        this.wQuCustomSegment.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.CustomSegment.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wQuCustomSegment);
        this.wQuCustomSegmentReference = new Link((Composite)gQuery, 4);
        this.wQuCustomSegmentReference.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Reference.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wQuCustomSegmentReference);
        this.wQuCustomSegmentReference.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                BareBonesBrowserLaunch.openURL(GaInputStepDialog.REFERENCE_SEGMENT_URI);
            }
        });
        this.wQuCustomSegmentReference.pack(true);
        FormData fdQuCustomSegment = new FormData();
        fdQuCustomSegment.top = new FormAttachment((Control)this.wUseSegmentEnabled, this.margin);
        fdQuCustomSegment.left = new FormAttachment((Control)this.wCustomSegmentEnabled, this.margin);
        fdQuCustomSegment.right = new FormAttachment(100, -this.wQuCustomSegmentReference.getBounds().width - this.margin);
        this.wQuCustomSegment.setLayoutData((Object)fdQuCustomSegment);
        FormData fdQuCustomSegmentReference = new FormData();
        fdQuCustomSegmentReference.top = new FormAttachment((Control)this.wUseSegmentEnabled, this.margin);
        fdQuCustomSegmentReference.left = new FormAttachment((Control)this.wQuCustomSegment, 0);
        fdQuCustomSegmentReference.right = new FormAttachment(100, 0);
        this.wQuCustomSegmentReference.setLayoutData((Object)fdQuCustomSegmentReference);
        this.wlQuSegment = new Label((Composite)gQuery, 131072);
        this.wlQuSegment.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Segment.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuSegment);
        FormData fdlQuSegment = new FormData();
        fdlQuSegment.top = new FormAttachment((Control)this.wQuCustomSegment, this.margin);
        fdlQuSegment.left = new FormAttachment(0, 0);
        fdlQuSegment.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuSegment.setLayoutData((Object)fdlQuSegment);
        this.wQuSegment = new CCombo((Composite)gQuery, 18444);
        this.props.setLook((Control)this.wQuSegment);
        this.wQuSegment.addModifyListener(this.lsMod);
        this.wQuSegment.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Segment.Tooltip", (String[])new String[0]));
        this.wGetSegments = new Button((Composite)gQuery, 8);
        this.wGetSegments.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.GetSegmentsButton.Label", (String[])new String[0]));
        this.wGetSegments.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.GetSegmentsButton.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wGetSegments);
        this.wGetSegments.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                GaInputStepDialog.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GaInputStepDialog.this.readGaSegments();
                    }
                });
            }
        });
        this.wGetSegments.pack(true);
        FormData fdQuSegment = new FormData();
        fdQuSegment.left = new FormAttachment(this.middle, 0);
        fdQuSegment.top = new FormAttachment((Control)this.wQuCustomSegment, this.margin);
        fdQuSegment.right = new FormAttachment(100, -this.wGetSegments.getBounds().width - this.margin);
        this.wQuSegment.setLayoutData((Object)fdQuSegment);
        FormData fdGetSegments = new FormData();
        fdGetSegments.left = new FormAttachment((Control)this.wQuSegment, 0);
        fdGetSegments.top = new FormAttachment((Control)this.wQuCustomSegment, this.margin);
        fdGetSegments.right = new FormAttachment(100, 0);
        this.wGetSegments.setLayoutData((Object)fdGetSegments);
        this.wlQuSamplingLevel = new Label((Composite)gQuery, 131072);
        this.wlQuSamplingLevel.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.SamplingLevel.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlQuSamplingLevel);
        FormData fdlQuSamplingLevel = new FormData();
        fdlQuSamplingLevel.top = new FormAttachment((Control)this.wQuSegment, this.margin);
        fdlQuSamplingLevel.left = new FormAttachment(0, 0);
        fdlQuSamplingLevel.right = new FormAttachment(this.middle, -this.margin);
        this.wlQuSamplingLevel.setLayoutData((Object)fdlQuSamplingLevel);
        this.wQuSamplingLevel = new CCombo((Composite)gQuery, 2056);
        this.props.setLook((Control)this.wQuSamplingLevel);
        this.wQuSamplingLevelReference = new Link((Composite)gQuery, 4);
        this.wQuSamplingLevelReference.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Reference.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wQuSamplingLevelReference);
        this.wQuSamplingLevelReference.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                BareBonesBrowserLaunch.openURL(GaInputStepDialog.REFERENCE_SAMPLING_LEVEL_URI);
            }
        });
        this.wQuSamplingLevelReference.pack(true);
        this.wQuSamplingLevel.addModifyListener(this.lsMod);
        this.wQuSamplingLevel.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.SamplingLevel.Tooltip", (String[])new String[0]));
        FormData fdQuSamplingLevel = new FormData();
        fdQuSamplingLevel.left = new FormAttachment(this.middle, 0);
        fdQuSamplingLevel.top = new FormAttachment((Control)this.wQuSegment, this.margin);
        fdQuSamplingLevel.right = new FormAttachment(100, -this.wQuSamplingLevelReference.getBounds().width - this.margin);
        FormData fdQuSamplingLevelReference = new FormData();
        fdQuSamplingLevelReference.top = new FormAttachment((Control)this.wQuSegment, this.margin);
        fdQuSamplingLevelReference.left = new FormAttachment((Control)this.wQuDimensions, 0);
        fdQuSamplingLevelReference.right = new FormAttachment(100, 0);
        this.wQuSamplingLevelReference.setLayoutData((Object)fdQuSamplingLevelReference);
        this.wQuSamplingLevel.setLayoutData((Object)fdQuSamplingLevel);
        this.wQuSamplingLevel.setItems(GaInputStepMeta.TYPE_SAMPLING_LEVEL_CODE);
        this.wQuSamplingLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GaInputStepDialog.this.getInput().setChanged();
            }
        });
        FormData fdQueryGroup = new FormData();
        fdQueryGroup.left = new FormAttachment(0, 0);
        fdQueryGroup.right = new FormAttachment(100, 0);
        fdQueryGroup.top = new FormAttachment((Control)this.gConnect, this.margin);
        gQuery.setLayoutData((Object)fdQueryGroup);
        gQuery.setTabList(new Control[]{this.wQuStartDate, this.wQuEndDate, this.wQuDimensions, this.wQuMetrics, this.wQuFilters, this.wQuSort, this.wUseSegmentEnabled, this.wCustomSegmentEnabled, this.wQuCustomSegment, this.wQuSegment, this.wGetSegments});
        this.wlLimit = new Label((Composite)this.shell, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.LimitSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(this.middle, -this.margin);
        fdlLimit.bottom = new FormAttachment(100, -50);
        this.wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text((Composite)this.shell, 18436);
        this.wLimit.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.LimitSize.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(this.lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(this.middle, 0);
        fdLimit.right = new FormAttachment(100, 0);
        fdLimit.bottom = new FormAttachment(100, -50);
        this.wLimit.setLayoutData((Object)fdLimit);
        this.wlFields = new Link((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Return.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.wlFields.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                BareBonesBrowserLaunch.openURL(GaInputStepDialog.REFERENCE_DIMENSION_AND_METRIC_URI);
            }
        });
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)gQuery, this.margin);
        this.wlFields.setLayoutData((Object)fdlReturn);
        int fieldWidgetCols = 5;
        int fieldWidgetRows = this.getInput().getFeedField() != null ? this.getInput().getFeedField().length : 1;
        ColumnInfo[] ciKeys = new ColumnInfo[fieldWidgetCols];
        ciKeys[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.FeedFieldType", (String[])new String[0]), 2, new String[]{"Dimension", "Metric", "Data Source Property", "Data Source Field"}, true);
        ciKeys[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.FeedField", (String[])new String[0]), 1, false, false);
        ciKeys[1].setUsingVariables(true);
        ciKeys[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.RenameTo", (String[])new String[0]), 1, false, false);
        ciKeys[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaBase.getTypes());
        ciKeys[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.Format", (String[])new String[0]), 5, 4);
        this.setTableView(new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciKeys, fieldWidgetRows, this.lsMod, this.props));
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)this.wlFields, this.margin);
        fdReturn.right = new FormAttachment(100, 0);
        fdReturn.bottom = new FormAttachment((Control)this.wLimit, -this.margin);
        this.getTableView().setLayoutData((Object)fdReturn);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GaInputStepDialog.this.getFields();
            }
        });
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.addListener(13, new Listener(){

            public void handleEvent(Event ev) {
                GaInputStepDialog.this.preview();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOK, this.wGet, this.wPreview, this.wCancel}, (int)this.margin, (Control)this.wLimit);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                GaInputStepDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                GaInputStepDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                GaInputStepDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wGaCustomProfile.addSelectionListener(this.lsDef);
        this.wQuStartDate.addSelectionListener(this.lsDef);
        this.wQuEndDate.addSelectionListener(this.lsDef);
        this.wQuDimensions.addSelectionListener(this.lsDef);
        this.wQuMetrics.addSelectionListener(this.lsDef);
        this.wQuFilters.addSelectionListener(this.lsDef);
        this.wQuSort.addSelectionListener(this.lsDef);
        this.wQuCustomSegment.addSelectionListener(this.lsDef);
        this.wQuSamplingLevel.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                GaInputStepDialog.this.cancel();
            }
        });
        this.fileChooser.addSelectionListener((SelectionListener)new SelectionAdapterFileDialogTextVar((LogChannelInterface)this.log, this.keyFilename, (AbstractMeta)this.transMeta, new SelectionAdapterOptions(SelectionOperation.FILE, new FilterType[]{FilterType.P12, FilterType.ALL}, FilterType.P12, new ProviderFilterType[]{ProviderFilterType.LOCAL})));
        this.setSize();
        this.getData();
        this.getInput().setChanged(this.backupChanged);
        this.wStepname.setFocus();
        this.shell.setTabList(new Control[]{this.wStepname, this.gConnect, gQuery, this.getTableView()});
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    void getFields() {
        Analytics.Data.Ga.Get query = this.getPreviewQuery();
        if (query == null) {
            return;
        }
        query.setMaxResults(Integer.valueOf(1));
        try {
            GaData dataFeed = (GaData)query.execute();
            if (dataFeed == null || dataFeed.getRows() == null || dataFeed.getRows().size() < 1) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setText("Query yields empty feed");
                mb.setMessage("The feed did not give any results. Please specify a query that returns data.");
                mb.open();
                return;
            }
            int i = 0;
            List colHeaders = dataFeed.getColumnHeaders();
            this.getTableView().table.setItemCount(colHeaders.size() + dataFeed.getProfileInfo().size());
            for (GaData.ColumnHeaders colHeader : colHeaders) {
                String name = colHeader.getName();
                String dataType = colHeader.getDataType();
                String columnType = colHeader.getColumnType();
                TableItem item = this.getTableView().table.getItem(i);
                if (columnType.equals("DIMENSION")) {
                    item.setText(1, "Dimension");
                    item.setText(2, name);
                    item.setText(3, name);
                    if (name.equalsIgnoreCase("ga:date")) {
                        item.setText(4, ValueMetaBase.getTypeDesc((int)3));
                        item.setText(5, "yyyyMMdd");
                    } else if (name.equalsIgnoreCase("ga:daysSinceLastVisit") || name.equalsIgnoreCase("ga:visitLength") || name.equalsIgnoreCase("ga:visitCount")) {
                        item.setText(4, ValueMetaBase.getTypeDesc((int)5));
                        item.setText(5, "#;-#");
                    } else if (name.equalsIgnoreCase("ga:latitude") || name.equalsIgnoreCase("ga:longitude")) {
                        item.setText(4, ValueMetaBase.getTypeDesc((int)1));
                        item.setText(5, "#.#;-#.#");
                    } else {
                        item.setText(4, ValueMetaBase.getTypeDesc((int)2));
                        item.setText(5, "");
                    }
                    ++i;
                    continue;
                }
                if (!columnType.equals("METRIC")) continue;
                item.setText(1, "Metric");
                item.setText(2, name);
                item.setText(3, name);
                if (dataType.compareToIgnoreCase("currency") == 0 || dataType.compareToIgnoreCase("float") == 0 || dataType.compareToIgnoreCase("percent") == 0 || dataType.compareToIgnoreCase("us_currency") == 0) {
                    item.setText(4, ValueMetaBase.getTypeDesc((int)1));
                    item.setText(5, "#.#;-#.#");
                } else if (dataType.compareToIgnoreCase("time") == 0 || dataType.compareToIgnoreCase("integer") == 0) {
                    item.setText(4, ValueMetaBase.getTypeDesc((int)5));
                    item.setText(5, "#;-#");
                } else {
                    item.setText(4, ValueMetaBase.getTypeDesc((int)2));
                    item.setText(5, "");
                }
                ++i;
            }
            TableItem item = this.getTableView().table.getItem(i);
            item.setText(1, "Data Source Property");
            item.setText(2, "ga:profileId");
            item.setText(3, "ga:profileId");
            item.setText(4, ValueMetaBase.getTypeDesc((int)2));
            item.setText(5, "");
            item = this.getTableView().table.getItem(++i);
            item.setText(1, "Data Source Property");
            item.setText(2, "ga:webPropertyId");
            item.setText(3, "ga:webPropertyId");
            item.setText(4, ValueMetaBase.getTypeDesc((int)2));
            item.setText(5, "");
            item = this.getTableView().table.getItem(++i);
            item.setText(1, "Data Source Property");
            item.setText(2, "ga:accountName");
            item.setText(3, "ga:accountName");
            item.setText(4, ValueMetaBase.getTypeDesc((int)2));
            item.setText(5, "");
            item = this.getTableView().table.getItem(++i);
            item.setText(1, "Data Source Field");
            item.setText(2, "dxp:tableId");
            item.setText(3, "dxp:tableId");
            item.setText(4, ValueMetaBase.getTypeDesc((int)2));
            item.setText(5, "");
            item = this.getTableView().table.getItem(++i);
            item.setText(1, "Data Source Field");
            item.setText(2, "dxp:tableName");
            item.setText(3, "dxp:tableName");
            item.setText(4, ValueMetaBase.getTypeDesc((int)2));
            item.setText(5, "");
            this.getTableView().removeEmptyRows();
            this.getTableView().setRowNums();
            this.getTableView().optWidth(true);
            this.getInput().setChanged();
        }
        catch (IOException ioe) {
            GoogleJsonResponseException gjre;
            IOException exceptionToDisplay = ioe;
            if (ioe instanceof GoogleJsonResponseException && (gjre = (GoogleJsonResponseException)ioe).getDetails() != null && gjre.getDetails().getMessage() != null) {
                exceptionToDisplay = new IOException(gjre.getDetails().getMessage(), (Throwable)gjre);
            }
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.RequestError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.RequestError.DialogMessage", (String[])new String[0]), (Exception)exceptionToDisplay);
        }
    }

    private void getInfo(GaInputStepMeta meta) {
        this.stepname = this.wStepname.getText();
        meta.setGaProfileName(this.wGaProfile.getText());
        meta.setGaAppName(this.wGaAppName.getText());
        meta.setOauthServiceAccount(this.wOauthAccount.getText());
        meta.setOAuthKeyFile(this.keyFilename.getText());
        if (!Utils.isEmpty((CharSequence)this.wGaProfile.getText())) {
            meta.setGaProfileTableId(this.profileTableIds.get(this.wGaProfile.getText()));
        } else {
            meta.setGaProfileTableId(null);
        }
        meta.setUseCustomTableId(this.wCustomProfileEnabled.getSelection());
        meta.setGaCustomTableId(this.wGaCustomProfile.getText());
        meta.setSegmentName(Utils.isEmpty((CharSequence)this.wQuSegment.getText()) ? "All Visits" : this.wQuSegment.getText());
        if (!Utils.isEmpty((CharSequence)this.wQuSegment.getText())) {
            meta.setSegmentId(this.segmentIds.get(this.wQuSegment.getText()));
        } else {
            meta.setSegmentId("gaid::-1");
        }
        meta.setStartDate(this.wQuStartDate.getText());
        meta.setEndDate(this.wQuEndDate.getText());
        meta.setDimensions(this.wQuDimensions.getText());
        meta.setMetrics(this.wQuMetrics.getText());
        meta.setFilters(this.wQuFilters.getText());
        meta.setSort(this.wQuSort.getText());
        meta.setUseSegment(this.wUseSegmentEnabled.getSelection());
        meta.setUseCustomSegment(this.wCustomSegmentEnabled.getSelection());
        meta.setCustomSegment(this.wQuCustomSegment.getText());
        meta.setSamplingLevel(this.wQuSamplingLevel.getText());
        int nrFields = this.getTableView().nrNonEmpty();
        meta.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.getTableView().getNonEmpty(i);
            meta.getFeedFieldType()[i] = item.getText(1);
            meta.getFeedField()[i] = item.getText(2);
            meta.getOutputField()[i] = item.getText(3);
            meta.getOutputType()[i] = ValueMetaBase.getType((String)item.getText(4));
            meta.getConversionMask()[i] = item.getText(5);
            if (meta.getOutputType()[i] >= 0) continue;
            meta.getOutputType()[i] = 2;
        }
        meta.setRowLimit(Const.toInt((String)this.wLimit.getText(), (int)0));
    }

    private void preview() {
        GaInputStepMeta oneMeta = new GaInputStepMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }

    protected Analytics.Data.Ga.Get getPreviewQuery() {
        try {
            String ids = this.wCustomProfileEnabled.getSelection() ? this.transMeta.environmentSubstitute(this.wGaCustomProfile.getText()) : this.profileTableIds.get(this.wGaProfile.getText());
            String metrics = this.transMeta.environmentSubstitute(this.wQuMetrics.getText());
            if (Utils.isEmpty((CharSequence)metrics)) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setText(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.NoMetricsSpecified.Title", (String[])new String[0]));
                mb.setMessage(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.NoMetricsSpecified.Message", (String[])new String[0]));
                mb.open();
                return null;
            }
            Analytics analytics = this.getAnalytics();
            if (analytics == null) {
                return null;
            }
            Analytics.Data.Ga.Get query = analytics.data().ga().get(ids, this.transMeta.environmentSubstitute(this.wQuStartDate.getText()), this.transMeta.environmentSubstitute(this.wQuEndDate.getText()), metrics);
            String dimensions = this.transMeta.environmentSubstitute(this.wQuDimensions.getText());
            if (!Utils.isEmpty((CharSequence)dimensions)) {
                query.setDimensions(dimensions);
            }
            if (this.wUseSegmentEnabled.getSelection()) {
                if (this.wCustomSegmentEnabled.getSelection()) {
                    query.setSegment(this.transMeta.environmentSubstitute(this.wQuCustomSegment.getText()));
                } else {
                    query.setSegment(this.segmentIds.get(this.wQuSegment.getText()));
                }
            }
            if (!Utils.isEmpty((CharSequence)this.wQuSamplingLevel.getText())) {
                query.setSamplingLevel(this.transMeta.environmentSubstitute(this.wQuSamplingLevel.getText()));
            }
            if (!Utils.isEmpty((CharSequence)this.wQuFilters.getText())) {
                query.setFilters(this.transMeta.environmentSubstitute(this.wQuFilters.getText()));
            }
            if (!Utils.isEmpty((CharSequence)this.wQuSort.getText())) {
                query.setSort(this.transMeta.environmentSubstitute(this.wQuSort.getText()));
            }
            return query;
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AuthenticationFailure.DialogTitle", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AuthenticationFailure.DialogMessage", (String[])new String[0]));
            mb.open();
            return null;
        }
    }

    protected void setActive() {
        boolean segment = this.wUseSegmentEnabled.getSelection();
        this.wCustomSegmentEnabled.setEnabled(segment);
        if (!segment) {
            this.wQuCustomSegment.setEnabled(false);
            this.wQuCustomSegmentReference.setEnabled(false);
            this.wQuSegment.setEnabled(false);
            this.wGetSegments.setEnabled(false);
        } else {
            boolean custom = this.wCustomSegmentEnabled.getSelection();
            this.wQuCustomSegment.setEnabled(custom);
            this.wQuCustomSegmentReference.setEnabled(custom);
            this.wQuSegment.setEnabled(!custom);
            this.wGetSegments.setEnabled(!custom);
        }
        boolean directTableId = this.wCustomProfileEnabled.getSelection();
        this.wGaProfile.setEnabled(!directTableId);
        this.wGetProfiles.setEnabled(!directTableId);
        this.wGaCustomProfile.setEnabled(directTableId);
        this.wGaCustomProfileReference.setEnabled(directTableId);
    }

    public void readGaProfiles() {
        try {
            Analytics analytics = this.getAnalytics();
            if (analytics == null) {
                return;
            }
            Analytics.Management.Profiles.List profiles = analytics.management().profiles().list("~all", "~all");
            Profiles profileList = (Profiles)profiles.execute();
            this.profileTableIds.clear();
            ArrayList<String> profileNames = new ArrayList<String>();
            for (Profile profile : profileList.getItems()) {
                String tableId = "ga:" + profile.getId();
                String profileName = tableId + " - profile: " + profile.getName();
                profileNames.add(profileName);
                this.profileTableIds.put(profileName, tableId);
            }
            this.wGaProfile.setItems(profileNames.toArray(new String[profileNames.size()]));
            if (profileNames.size() > 0) {
                this.wGaProfile.select(0);
            }
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AuthenticationFailure.DialogTitle", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AuthenticationFailure.DialogMessage", (String[])new String[0]));
            mb.open();
        }
    }

    public void readGaSegments() {
        try {
            Analytics analytics = this.getAnalytics();
            if (analytics == null) {
                return;
            }
            Segments segments = (Segments)analytics.management().segments().list().execute();
            ArrayList<String> segmentNames = new ArrayList<String>(20);
            this.segmentIds.clear();
            for (Segment segmentEntry : segments.getItems()) {
                segmentNames.add(segmentEntry.getName());
                this.segmentIds.put(segmentEntry.getName(), "gaid::" + segmentEntry.getId());
            }
            this.wQuSegment.setItems(segmentNames.toArray(new String[segmentNames.size()]));
            if (segmentNames.size() > 0) {
                this.wQuSegment.select(0);
            }
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AuthenticationFailure.DialogTitle", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AuthenticationFailure.DialogMessage", (String[])new String[0]));
            mb.open();
        }
    }

    public void getData() {
        if (this.getInput().getGaAppName() != null) {
            this.wGaAppName.setText(this.getInput().getGaAppName());
        }
        this.wOauthAccount.setText(Const.NVL((String)this.getInput().getOAuthServiceAccount(), (String)""));
        this.keyFilename.setText(Const.NVL((String)this.getInput().getOAuthKeyFile(), (String)""));
        if (this.getInput().getGaProfileName() != null) {
            this.wGaProfile.setText(this.getInput().getGaProfileName());
            this.profileTableIds.clear();
            this.profileTableIds.put(this.getInput().getGaProfileName(), this.getInput().getGaProfileTableId());
        }
        if (this.getInput().isUseCustomTableId()) {
            this.wCustomProfileEnabled.setSelection(true);
        } else {
            this.wCustomProfileEnabled.setSelection(false);
        }
        if (this.getInput().getGaCustomTableId() != null) {
            this.wGaCustomProfile.setText(this.getInput().getGaCustomTableId());
        }
        if (this.getInput().getStartDate() != null) {
            this.wQuStartDate.setText(this.getInput().getStartDate());
        }
        if (this.getInput().getEndDate() != null) {
            this.wQuEndDate.setText(this.getInput().getEndDate());
        }
        if (this.getInput().getDimensions() != null) {
            this.wQuDimensions.setText(this.getInput().getDimensions());
        }
        if (this.getInput().getMetrics() != null) {
            this.wQuMetrics.setText(this.getInput().getMetrics());
        }
        if (this.getInput().getFilters() != null) {
            this.wQuFilters.setText(this.getInput().getFilters());
        }
        if (this.getInput().getSort() != null) {
            this.wQuSort.setText(this.getInput().getSort());
        }
        if (this.getInput().isUseSegment()) {
            this.wUseSegmentEnabled.setSelection(true);
        } else {
            this.wUseSegmentEnabled.setSelection(false);
        }
        if (this.getInput().isUseCustomSegment()) {
            this.wCustomSegmentEnabled.setSelection(true);
        } else {
            this.wCustomSegmentEnabled.setSelection(false);
        }
        if (this.getInput().getCustomSegment() != null) {
            this.wQuCustomSegment.setText(this.getInput().getCustomSegment());
        }
        if (this.getInput().getSegmentName() != null) {
            this.wQuSegment.setText(this.getInput().getSegmentName());
            this.segmentIds.clear();
            this.segmentIds.put(this.getInput().getSegmentName(), this.getInput().getSegmentId());
        }
        if (this.getInput().getSamplingLevel() != null) {
            this.wQuSamplingLevel.setText(this.getInput().getSamplingLevel());
        }
        if (this.getInput().getFeedField() != null) {
            for (int i = 0; i < this.getInput().getFeedField().length; ++i) {
                TableItem item = this.getTableView().table.getItem(i);
                if (this.getInput().getFeedFieldType()[i] != null) {
                    item.setText(1, this.getInput().getFeedFieldType()[i]);
                }
                if (this.getInput().getFeedField()[i] != null) {
                    item.setText(2, this.getInput().getFeedField()[i]);
                }
                if (this.getInput().getOutputField()[i] != null) {
                    item.setText(3, this.getInput().getOutputField()[i]);
                }
                item.setText(4, ValueMetaBase.getTypeDesc((int)this.getInput().getOutputType()[i]));
                if (this.getInput().getConversionMask()[i] == null) continue;
                item.setText(5, this.getInput().getConversionMask()[i]);
            }
        }
        this.getTableView().setRowNums();
        this.getTableView().optWidth(true);
        this.wLimit.setText(this.getInput().getRowLimit() + "");
        this.setActive();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.getInput().setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        this.getInfo(this.getInput());
        this.dispose();
    }

    private void createOauthServiceCredentialsControls() {
        this.wlOauthAccount = new Label((Composite)this.gConnect, 131072);
        this.wlOauthAccount.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.OauthAccount.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOauthAccount);
        FormData fdlOathAccount = new FormData();
        fdlOathAccount.left = new FormAttachment(0, 0);
        fdlOathAccount.top = new FormAttachment((Control)this.wGaAppName, this.margin);
        fdlOathAccount.right = new FormAttachment(this.middle, -this.margin);
        this.wlOauthAccount.setLayoutData((Object)fdlOathAccount);
        this.wOauthAccount = new TextVar((VariableSpace)this.transMeta, (Composite)this.gConnect, 18436);
        this.wOauthAccount.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.OauthAccount.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOauthAccount);
        this.wOauthAccount.addModifyListener(this.lsMod);
        FormData fdOathAccount = new FormData();
        fdOathAccount.left = new FormAttachment(this.middle, 0);
        fdOathAccount.top = new FormAttachment((Control)this.wGaAppName, this.margin);
        fdOathAccount.right = new FormAttachment(100, -this.margin);
        this.wOauthAccount.setLayoutData((Object)fdOathAccount);
        this.fileChooser = new Button((Composite)this.gConnect, 0x1000008);
        this.fileChooser.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.props.setLook((Control)this.fileChooser);
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wOauthAccount, this.margin);
        this.fileChooser.setLayoutData((Object)fdbFilename);
        Label wlFilename = new Label((Composite)this.gConnect, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.KeyFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.top = new FormAttachment((Control)this.wOauthAccount, this.margin);
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        this.keyFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.gConnect, 18436);
        this.keyFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.KeyFilename.Tooltip", (String[])new String[0]));
        this.keyFilename.addModifyListener(this.lsMod);
        this.props.setLook((Control)this.keyFilename);
        FormData fdFilename = new FormData();
        fdFilename.top = new FormAttachment((Control)this.wOauthAccount, this.margin);
        fdFilename.left = new FormAttachment(this.middle, 0);
        fdFilename.right = new FormAttachment((Control)this.fileChooser, -this.margin);
        this.keyFilename.setLayoutData((Object)fdFilename);
    }

    private Analytics getAnalytics() {
        try {
            this.getInfo(this.getInput());
            return GoogleAnalyticsApiFacade.createFor(this.transMeta.environmentSubstitute(this.wGaAppName.getText()), this.transMeta.environmentSubstitute(this.wOauthAccount.getText()), this.transMeta.environmentSubstitute(this.keyFilename.getText())).getAnalytics();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.RequestError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.RequestError.DialogMessage", (String[])new String[0]), e);
            return null;
        }
    }

    TableView getTableView() {
        return this.wFields;
    }

    void setTableView(TableView wFields) {
        this.wFields = wFields;
    }

    GaInputStepMeta getInput() {
        return this.input;
    }

    void setInput(GaInputStepMeta input) {
        this.input = input;
    }
}

